<?php


/**
 * This class adds structure of 'artykul' table to 'artykulymi' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    artykulymi.map
 */
class ArtykulMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'artykulymi.map.ArtykulMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(ArtykulPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(ArtykulPeer::TABLE_NAME);
		$tMap->setPhpName('Artykul');
		$tMap->setClassname('Artykul');

		$tMap->setUseIdGenerator(true);

		$tMap->addPrimaryKey('ARTYKUL_ID', 'ArtykulId', 'INTEGER', true, null);

		$tMap->addColumn('TYTUL', 'Tytul', 'VARCHAR', true, 255);

		$tMap->addColumn('LID', 'Lid', 'LONGVARCHAR', false, null);

		$tMap->addColumn('START', 'Start', 'INTEGER', false, null);

		$tMap->addColumn('STOP', 'Stop', 'INTEGER', false, null);

		$tMap->addColumn('SLUG', 'Slug', 'VARCHAR', true, 128);

		$tMap->addForeignKey('RUBRYKA_ID', 'RubrykaId', 'INTEGER', 'rubryka', 'RUBRYKA_ID', false, null);

		$tMap->addForeignKey('PODRUBRYKA_ID', 'PodrubrykaId', 'INTEGER', 'podrubryka', 'PODRUBRYKA_ID', false, null);

		$tMap->addForeignKey('NUMER_ID', 'NumerId', 'INTEGER', 'numer', 'NUMER_ID', false, null);

		$tMap->addColumn('LICZBASTRON', 'Liczbastron', 'INTEGER', false, null);

	} // doBuild()

} // ArtykulMapBuilder
