<?php


/**
 * This class adds structure of 'artykul_has_autor' table to 'artykulymi' DatabaseMap object.
 *
 *
 *
 * These statically-built map classes are used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 * @package    artykulymi.map
 */
class ArtykulHasAutorMapBuilder implements MapBuilder {

	/**
	 * The (dot-path) name of this class
	 */
	const CLASS_NAME = 'artykulymi.map.ArtykulHasAutorMapBuilder';

	/**
	 * The database map.
	 */
	private $dbMap;

	/**
	 * Tells us if this DatabaseMapBuilder is built so that we
	 * don't have to re-build it every time.
	 *
	 * @return     boolean true if this DatabaseMapBuilder is built, false otherwise.
	 */
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	/**
	 * Gets the databasemap this map builder built.
	 *
	 * @return     the databasemap
	 */
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	/**
	 * The doBuild() method builds the DatabaseMap
	 *
	 * @return     void
	 * @throws     PropelException
	 */
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap(ArtykulHasAutorPeer::DATABASE_NAME);

		$tMap = $this->dbMap->addTable(ArtykulHasAutorPeer::TABLE_NAME);
		$tMap->setPhpName('ArtykulHasAutor');
		$tMap->setClassname('ArtykulHasAutor');

		$tMap->setUseIdGenerator(false);

		$tMap->addForeignPrimaryKey('ARTYKUL_ID', 'ArtykulId', 'INTEGER' , 'artykul', 'ARTYKUL_ID', true, null);

		$tMap->addForeignPrimaryKey('AUTOR_ID', 'AutorId', 'INTEGER' , 'autor', 'AUTOR_ID', true, null);

	} // doBuild()

} // ArtykulHasAutorMapBuilder
