<?php

class Actions extends ActionsBase
{

    public function execute_list()
    {

        $kolumny = new TabelaRocznikow();

        if ($kolumny->incorrectVars()) {
            $this->execute_404();
            return;
        } else if ($kolumny->correctVars()) {
            $kolumny->setIndex($_GET['orderslug']);
            $kolumny->setOrder($_GET['order']);
        }

        $kolumny->assignCurrent();
        $c = $kolumny->getCriteria();
        $kolumny->reverseOrder();
        $kolumny->addURLs('index.php?module=rocznik&action=list');
        $this->set('kolumny', $kolumny->getColumns());

        if (isset($_GET['page'])) {
            if (str_ievpi($_GET['page'])) {
                $strona = $_GET['page'];
            } else {
                $this->execute_404();
                return;
            }
        } else {
            $strona = '1';
        }

        $pager = new Pager('Rocznik', ILE_NA_STRONIE, $c);

        if ($pager->isValidPage($strona)) {
            $pager->setPage($strona);
            $pager->assignRecords();
            $pager->setBaseURL(
                'index.php?module=rocznik&action=list&order=' .
                    $kolumny->getCurrentOrder() .
                    '&orderslug=' .
                    $kolumny->getIndex() .
                    '&page='
            );
            
            $this->set('pager', $pager);
            
        } else {
            $this->execute_404();
        }

    }              
    
    public function execute_show()
    {
        if (
            str_ivslug($_GET['slug']) &&
            isset($_GET['slug']) &&
            ($rocznik = RocznikPeer::retrieveBySlug($_GET['slug']))
        ) {

            $this->set('rocznik', $rocznik);
            
            $wskaznik = new WskaznikRocznika($rocznik);
            $this->set('wskaznik', $wskaznik->getPointers());

            $kolumny = new TabelaNumerow();

            if ($kolumny->incorrectVars()) {
                $this->execute_404();
                return;
            } else if ($kolumny->correctVars()) {
                $kolumny->setIndex($_GET['orderslug']);
                $kolumny->setOrder($_GET['order']);
            }

            $kolumny->assignCurrent();
            $c = $kolumny->getCriteria();
            $kolumny->reverseOrder();
            $kolumny->addURLs('index.php?module=rocznik&action=show&slug=' . $rocznik->getSlug());
            $this->set('kolumny', $kolumny->getColumns());

            if (isset($_GET['page'])) {
                if (str_ievpi($_GET['page'])) {
                    $strona = $_GET['page'];
                } else {
                    $this->execute_404();
                    return;
                }
            } else {
                $strona = '1';
            }

            $c->addJoin(RocznikPeer::ROCZNIK_ID, NumerPeer::ROCZNIK_ID);
            $c->add(RocznikPeer::ROCZNIK_ID, $rocznik->getRocznikId());

            $pager = new Pager('Numer', ILE_NA_STRONIE, $c);

            if ($pager->isValidPage($strona)) {
                $pager->setPage($strona);
                $pager->assignRecords();
                
                $pager->setBaseURL(
                    'index.php?module=rocznik&action=show&slug=' . $rocznik->getSlug() . 'order=' .
                        $kolumny->getCurrentOrder() .
                        '&orderslug=' .
                        $kolumny->getIndex() .
                        '&page='
                );
                $this->set('pager', $pager);
            } else {
                $this->execute_404();
            }


        } else {

            $this->execute_404();

        }

    }
    
}