using Northwind.GraphQL; // Query
using Packt.Shared; // Metoda rozszerzajca AddNorthwindContext

var builder = WebApplication.CreateBuilder(args);

builder.Services.AddNorthwindContext();

builder.Services
  .AddGraphQLServer()
  .RegisterDbContext<NorthwindContext>()
  .AddQueryType<Query>()
  .AddMutationType<Mutation>();

var app = builder.Build();

app.MapGet("/", () => "Przejd do strony: https://localhost:5111/graphql");

app.MapGraphQL();

app.Run();
