﻿using CommunityToolkit.Mvvm.ComponentModel; // ObservableObject
using CommunityToolkit.Mvvm.Input; // [RelayCommand]
using CommunityToolkit.Maui.Alerts; // Toast
using CommunityToolkit.Maui.Core; // IToast, ToastDuration

namespace Northwind.Maui.Blazor.Client.Views.Orders;

internal partial class DeviceInfoViewModel : ObservableObject
{
  public string DisplayPixelWidth =>
    $"Szerokość ekranu: {DeviceDisplay.Current.MainDisplayInfo.Width} px";

  public string DisplayDensity =>
    $"Gęstość ekranu: {DeviceDisplay.Current.MainDisplayInfo.Density} px";

  public string DisplayOrientation =>
    $"Orientacja: {DeviceDisplay.Current.MainDisplayInfo.Orientation}";

  public string DisplayRotation =>
    $"Obrót: {DeviceDisplay.Current.MainDisplayInfo.Rotation}";

  public string DisplayRefreshRate =>
    $"Częst. odświeżania: {DeviceDisplay.Current.MainDisplayInfo.RefreshRate} Hz";

  public string DeviceModel => DeviceInfo.Current.Model;

  public string DeviceType =>
    $"Urządzenie: {DeviceInfo.Current.DeviceType} {DeviceInfo.Current.Idiom}";

  public string DeviceVersion => DeviceInfo.Current.VersionString;

  public string DevicePlatform =>
    $"System operacyjny: {DeviceInfo.Current.Platform}";

  [RelayCommand]
  private async Task NavigateTo(string pageName)
  {
    await Shell.Current.GoToAsync($"//{pageName}");
  }

  [RelayCommand]
  private async Task PopupToast()
  {
    IToast toast = Toast.Make(message: "Wyskakujące powiadomienie",
      duration: ToastDuration.Short, textSize: 18);

    await toast.Show();
  }
}
