﻿using Packt.Shared;

WriteLine("Rejestracja użytkownika Alicja z hasłem Ha$ł0:");
User alice = Protector.Register("Alicja", " Ha$ł0");

WriteLine($"  Nazwa: {alice.Name}");
WriteLine($"  Sól: {alice.Salt}");
WriteLine("  Hasło (skrót): {0}",
  arg0: alice.SaltedHashedPassword);
WriteLine();

Write("Podaj nazwę nowego użytkownika: ");
string? username = ReadLine();
if (string.IsNullOrEmpty(username))
{
  username = "Robert";
}

Write($"Wpisz hasło użytkownika {username}: ");
string? password = ReadLine();
if (string.IsNullOrEmpty(password))
{
  password = "Ha$ł0";
}

WriteLine("Rejestracja nowego użytkownika:");
User newUser = Protector.Register(username, password);
WriteLine($"  Nazwa: {newUser.Name}");
WriteLine($"  Sól: {newUser.Salt}");
WriteLine("  Hasło (skrót): {0}",
  arg0: newUser.SaltedHashedPassword);
WriteLine();

bool correctPassword = false;

while (!correctPassword)
{
  Write("Podaj nazwę użytkownika do zalogowania: ");
  string? loginUsername = ReadLine();
  if (string.IsNullOrEmpty(loginUsername))
  {
    WriteLine("Nazwa nie może być pusta.");
    Write("Naciśnij Ctrl+C, aby zakończyć program, lub ENTER, aby ponowić próbę.");
    ReadLine();
    continue;
  }

  Write("Podaj hasło do logowania: ");
  string? loginPassword = ReadLine();
  if (string.IsNullOrEmpty(loginPassword))
  {
    WriteLine("Hasło nie może być puste.");
    Write("Naciśnij Ctrl+C, aby zakończyć program lub ENTER, aby ponowić próbę.");
    ReadLine();
    continue;
  }

  correctPassword = Protector.CheckPassword(
    loginUsername, loginPassword);

  if (correctPassword)
  {
    WriteLine($"Dane poprawne! Użytkownik {loginUsername} został zalogowany.");
  }
  else
  {
    WriteLine("Błędna nazwa użytkownika lub hasło. Spróbuj ponownie.");
  }
}
