﻿using GeneratingPdf.Document; // CatalogDocument
using GeneratingPdf.Models; // Catalog, Category
using QuestPDF.Fluent; // Metoda rozszerzająca GeneratePdf

string filename = "catalog.pdf";

Catalog model = new()
{
  Categories = new()
  {
    new() { CategoryId = 1, CategoryName = "Napoje"},
    new() { CategoryId = 2, CategoryName = "Przyprawy"},
    new() { CategoryId = 3, CategoryName = "Słodycze"},
    new() { CategoryId = 4, CategoryName = "Nabiał"},
    new() { CategoryId = 5, CategoryName = "Płatki zbożowe"},
    new() { CategoryId = 6, CategoryName = "Mięso/Drób"},
    new() { CategoryId = 7, CategoryName = "Warzywa"},
    new() { CategoryId = 8, CategoryName = "Owoce morza"},
  }
};

CatalogDocument document = new(model);
document.GeneratePdf(filename);

WriteLine($"Wygenerowany plik PDF: {filename}");

try
{
  if (OperatingSystem.IsWindows())
  {
    System.Diagnostics.Process.Start("explorer.exe", filename);
  }
  else if (OperatingSystem.IsMacOS())
  {
    System.Diagnostics.Process.Start(
      "/Applications/TextEdit.app/Contents/MacOS/TextEdit", filename);
  }
  else
  {
    WriteLine("Otwórz ręcznie plik.");
  }
}
catch (Exception ex)
{
  WriteLine($"Błąd {ex.GetType()}, komunikat {ex.Message}");
}
