<?php

require "accept.php";

spl_autoload_register(function ($classname) {
    require ("inc/" . strtolower($classname) . ".php");
});

// Tworzy format widoku
$accepted_formats = parseAcceptHeader();
$supported_formats = array("application/json", "application/xml");
foreach($accepted_formats as $format) {
    if(in_array($format, $supported_formats)) {
        // użycie tego formatu
        break;
    }
}

switch($format) {
    case "application/xml":
        $view = new XmlView();
        break;
    case "application/json":
    default:
        $view = new JsonView();
        break;
}


set_exception_handler(function ($exception) use ($view) {
    $data = array("message" => $exception->getMessage());
    if($exception->getCode()) {
        $view->status = $exception->getCode();
    } else {
        $view->status = 500;
    }
    $view->render($data);
});

// dozwolone kontrolery
$controllers = array("user", "post", "category");

// przetwarza URL: najpierw jest klasa, potem funkcja
$pieces = explode('/', $_SERVER['PATH_INFO']);
if(in_array($pieces[1], $controllers)) {
    $classname = $pieces[1];
    $functionname = $pieces[2];

    $class = new $classname();
    $data = $class->$functionname();

    $view->render($data);
} else {
    throw new Exception("Nie rozpoznano żądania.", 400);
}
