# -*- coding: UTF-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _

from utils.fields import MultilingualCharField, MultilingualTextField
from utils.models import CreatorMixin


class Book(CreatorMixin):
    author = models.CharField(_("author"), max_length=200)
    title = MultilingualCharField(_("title"), max_length=200)
    description = MultilingualTextField(_("description"), blank=True)

    class Meta:
        verbose_name = _("book")
        verbose_name_plural = _("books")

    def __unicode__(self):
        return self.title