# -*- coding: utf-8 -*-
from south.utils import datetime_utils as datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding M2M table for field categories on 'Idea'
        m2m_table_name = db.shorten_name(u'demo_app_idea_categories')
        db.create_table(m2m_table_name, (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('idea', models.ForeignKey(orm[u'demo_app.idea'], null=False)),
            ('category', models.ForeignKey(orm[u'demo_app.category'], null=False))
        ))
        db.create_unique(m2m_table_name, ['idea_id', 'category_id'])


    def backwards(self, orm):
        # Removing M2M table for field categories on 'Idea'
        db.delete_table(db.shorten_name(u'demo_app_idea_categories'))


    models = {
        u'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        u'demo_app.category': {
            'Meta': {'object_name': 'Category'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'title_de': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'title_en': ('django.db.models.fields.CharField', [], {'max_length': '200'}),
            'title_fr': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'title_lt': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'})
        },
        u'demo_app.idea': {
            'Meta': {'object_name': 'Idea'},
            'categories': ('django.db.models.fields.related.ManyToManyField', [], {'symmetrical': 'False', 'related_name': "'ideas'", 'blank': 'True', 'to': u"orm['demo_app.Category']"}),
            'category': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['demo_app.Category']", 'null': 'True', 'blank': 'True'}),
            'created': ('django.db.models.fields.DateTimeField', [], {}),
            'description_de': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            'description_en': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            'description_fr': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            'description_lt': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_original': ('django.db.models.fields.BooleanField', [], {}),
            'meta_author': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'meta_copyright': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'meta_description': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'meta_keywords': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'modified': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'subtitle_de': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'subtitle_en': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'subtitle_fr': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'subtitle_lt': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'title_de': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'title_en': ('django.db.models.fields.CharField', [], {'max_length': '200'}),
            'title_fr': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'title_lt': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'})
        },
        u'demo_app.like': {
            'Meta': {'object_name': 'Like'},
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['contenttypes.ContentType']"}),
            'created': ('django.db.models.fields.DateTimeField', [], {}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'modified': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'object_id': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'owner_content_type': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'owner'", 'to': u"orm['contenttypes.ContentType']"}),
            'owner_object_id': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'})
        }
    }

    complete_apps = ['demo_app']