# -*- coding: utf-8 -*-
from south.utils import datetime_utils as datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'Category'
        db.create_table(u'demo_app_category', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('title_en', self.gf('django.db.models.fields.CharField')(max_length=200)),
            ('title_de', self.gf('django.db.models.fields.CharField')(max_length=200, blank=True)),
            ('title_fr', self.gf('django.db.models.fields.CharField')(max_length=200, blank=True)),
            ('title_lt', self.gf('django.db.models.fields.CharField')(max_length=200, blank=True)),
        ))
        db.send_create_signal(u'demo_app', ['Category'])

        # Adding model 'Idea'
        db.create_table(u'demo_app_idea', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('created', self.gf('django.db.models.fields.DateTimeField')()),
            ('modified', self.gf('django.db.models.fields.DateTimeField')(null=True)),
            ('meta_keywords', self.gf('django.db.models.fields.CharField')(max_length=255, blank=True)),
            ('meta_description', self.gf('django.db.models.fields.CharField')(max_length=255, blank=True)),
            ('meta_author', self.gf('django.db.models.fields.CharField')(max_length=255, blank=True)),
            ('meta_copyright', self.gf('django.db.models.fields.CharField')(max_length=255, blank=True)),
            ('is_original', self.gf('django.db.models.fields.BooleanField')()),
            ('category', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['demo_app.Category'], null=True, blank=True)),
            ('description_en', self.gf('django.db.models.fields.TextField')(blank=True)),
            ('description_de', self.gf('django.db.models.fields.TextField')(blank=True)),
            ('description_fr', self.gf('django.db.models.fields.TextField')(blank=True)),
            ('description_lt', self.gf('django.db.models.fields.TextField')(blank=True)),
            ('title_en', self.gf('django.db.models.fields.CharField')(max_length=200)),
            ('title_de', self.gf('django.db.models.fields.CharField')(max_length=200, blank=True)),
            ('title_fr', self.gf('django.db.models.fields.CharField')(max_length=200, blank=True)),
            ('title_lt', self.gf('django.db.models.fields.CharField')(max_length=200, blank=True)),
        ))
        db.send_create_signal(u'demo_app', ['Idea'])

        # Adding model 'Like'
        db.create_table(u'demo_app_like', (
            (u'id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('created', self.gf('django.db.models.fields.DateTimeField')()),
            ('modified', self.gf('django.db.models.fields.DateTimeField')(null=True)),
            ('content_type', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['contenttypes.ContentType'])),
            ('object_id', self.gf('django.db.models.fields.CharField')(default='', max_length=255)),
            ('owner_content_type', self.gf('django.db.models.fields.related.ForeignKey')(related_name='owner', to=orm['contenttypes.ContentType'])),
            ('owner_object_id', self.gf('django.db.models.fields.CharField')(default='', max_length=255)),
        ))
        db.send_create_signal(u'demo_app', ['Like'])


    def backwards(self, orm):
        # Deleting model 'Category'
        db.delete_table(u'demo_app_category')

        # Deleting model 'Idea'
        db.delete_table(u'demo_app_idea')

        # Deleting model 'Like'
        db.delete_table(u'demo_app_like')


    models = {
        u'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        u'demo_app.category': {
            'Meta': {'object_name': 'Category'},
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'title_de': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'title_en': ('django.db.models.fields.CharField', [], {'max_length': '200'}),
            'title_fr': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'title_lt': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'})
        },
        u'demo_app.idea': {
            'Meta': {'object_name': 'Idea'},
            'category': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['demo_app.Category']", 'null': 'True', 'blank': 'True'}),
            'created': ('django.db.models.fields.DateTimeField', [], {}),
            'description_de': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            'description_en': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            'description_fr': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            'description_lt': ('django.db.models.fields.TextField', [], {'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_original': ('django.db.models.fields.BooleanField', [], {}),
            'meta_author': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'meta_copyright': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'meta_description': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'meta_keywords': ('django.db.models.fields.CharField', [], {'max_length': '255', 'blank': 'True'}),
            'modified': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'title_de': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'title_en': ('django.db.models.fields.CharField', [], {'max_length': '200'}),
            'title_fr': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'}),
            'title_lt': ('django.db.models.fields.CharField', [], {'max_length': '200', 'blank': 'True'})
        },
        u'demo_app.like': {
            'Meta': {'object_name': 'Like'},
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['contenttypes.ContentType']"}),
            'created': ('django.db.models.fields.DateTimeField', [], {}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'modified': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'object_id': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'}),
            'owner_content_type': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'owner'", 'to': u"orm['contenttypes.ContentType']"}),
            'owner_object_id': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '255'})
        }
    }

    complete_apps = ['demo_app']