# -*- coding: UTF-8 -*-
import os
from django.utils.translation import ugettext_lazy as _
from django.db import models
from django.utils.text import slugify


def upload_to(instance, filename):
    filename_base, filename_ext = os.path.splitext(filename)
    return 'tracks/%s--%s%s' % (
        slugify(instance.artist),
        slugify(instance.name),
        filename_ext.lower(),
    )


class Track(models.Model):
    name = models.CharField(_("Nazwa"), max_length=250)
    artist = models.CharField(_("Artysta"), max_length=250)
    url = models.URLField(_("URL"))
    image = models.ImageField(_("Obraz"), upload_to=upload_to, blank=True, null=True)

    class Meta:
        verbose_name = _(u"cieka")
        verbose_name_plural = _(u"cieki")

    def __unicode__(self):
        return u"%s - %s" % (self.artist, self.name)
