# -*- coding: UTF-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django.core.urlresolvers import reverse

from utils.models import CreationModificationDateMixin
from utils.models import UrlMixin

TYPE_CHOICES = (
    ('searching', _("Szukanie")),
    ('offering', _("Oferowanie")),
)


class Category(models.Model):
    title = models.CharField(_(u"Tytu"), max_length=200)

    def __unicode__(self):
        return self.title

    class Meta:
        verbose_name = _("Kategoria")
        verbose_name_plural = _("Kategorie")


class Bulletin(CreationModificationDateMixin, UrlMixin):
    bulletin_type = models.CharField(_("Typ"), max_length=20, choices=TYPE_CHOICES)
    category = models.ForeignKey(Category, verbose_name=_("Kategoria"))

    title = models.CharField(_(u"Tytu"), max_length=255)
    description = models.TextField(_("Opis"), max_length=300)

    contact_person = models.CharField(_("Osoba kontaktowa"), max_length=255)
    phone = models.CharField(_("Nr. telefonu"), max_length=200, blank=True)
    email = models.CharField(_("E-mail"), max_length=254, blank=True)

    image = models.ImageField(_("Obraz"), max_length=255, upload_to="bulletin_board/", blank=True)

    class Meta:
        verbose_name = _("Informacja")
        verbose_name_plural = _("Informacje")
        ordering = ("-created",)

    def __unicode__(self):
        return self.title

    def get_url_path(self):
        try:
            path = reverse("bulletin_detail", kwargs={'pk': self.pk})
        except:
            # the apphook is not attached yet
            return ""
        else:
            return path