# -*- coding: UTF-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django.conf import settings
from utils.models import ObjectRelationMixin, CreationModificationDateMixin


class Like(CreationModificationDateMixin, ObjectRelationMixin(is_required=True)):
    user = models.ForeignKey(settings.AUTH_USER_MODEL)

    class Meta:
        verbose_name = _("like")
        verbose_name_plural = _("likes")
        ordering = ('-created',)

    def __unicode__(self):
        return _(u"%(user)s likes %(obj)s") % {
            'user': self.user,
            'obj': self.content_object,
        }
