# -*- coding: UTF-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _

from utils.models import CreationModificationDateMixin

from mptt.models import MPTTModel
from mptt.fields import TreeForeignKey, TreeManyToManyField


class Category(MPTTModel, CreationModificationDateMixin):
    parent = TreeForeignKey("self", blank=True, null=True)
    title = models.CharField(_("Title"), max_length=200)

    def __unicode__(self):
        return self.title

    class Meta:
        ordering = ["tree_id", "lft"]
        verbose_name = _("Kategoria")
        verbose_name_plural = _("Kategorie")

    # def save(self, *args, **kwargs):
    #     if not self.pk:
    #         Category.objects.insert_node(self, self.parent)
    #     super(Category, self).save(*args, **kwargs)


class Movie(CreationModificationDateMixin):
    title = models.CharField(_(u"Tytuł"), max_length=255)
    categories = TreeManyToManyField(Category, verbose_name=_("Kategorie"))

    def __unicode__(self):
        return self.title

    class Meta:
        verbose_name = _("Film")
        verbose_name_plural = _("Filmy")
