# -*- coding: UTF-8 -*-
from django.contrib.admin.views import main
from django.utils.translation import get_language

class ExtendedChangeList(main.ChangeList):

    def get_translated_list(self, model, field_list):
        language = get_language()
        translated_list = []
        opts = model._meta
        virtual_fields = dict((f.name, f) for f in opts.virtual_fields)
        for field_name in field_list:
            if field_name != "action_checkbox":
                field = virtual_fields.get(field_name, None)
                if field and field.__class__.__name__.startswith("Multilingual"):
                    field_name += "_" + language
            translated_list.append(field_name)
        return translated_list

    def __init__(self, request, model, list_display, list_display_links,
        list_filter, date_hierarchy, search_fields, list_select_related,
        list_per_page, list_max_show_all, list_editable, model_admin):

        list_display = self.get_translated_list(model, list_display)
        list_display_links = self.get_translated_list(model, list_display_links)
        #list_filter = self.get_translated_list(model, list_filter)
        #list_editable = self.get_translated_list(model, list_editable)
        #search_fields = self.get_translated_list(model, search_fields)
        #if model_admin.ordering:
        #    model_admin.ordering = self.get_translated_list(model, model_admin.ordering)
        #elif model._meta.ordering:
        #    model_admin.ordering = self.get_translated_list(model, model._meta.ordering)

        super(ExtendedChangeList, self).__init__(request, model, list_display, list_display_links,
            list_filter, date_hierarchy, search_fields, list_select_related,
            list_per_page, list_max_show_all, list_editable, model_admin)

main.ChangeList = ExtendedChangeList


from django.utils import text
from slugify import slugify_de as awesome_slugify
awesome_slugify.to_lower = True

text.slugify = awesome_slugify