# -*- coding: UTF-8 -*-
from django.shortcuts import render
from models import Bulletin
from forms import BulletinSearchForm


def bulletin_list(request):
    bulletins = Bulletin.objects.all()
    form = BulletinSearchForm(request.REQUEST)
    if form.is_valid():
        if form.cleaned_data['bulletin_type']:
            bulletins = bulletins.filter(bulletin_type=form.cleaned_data['bulletin_type'])
        if form.cleaned_data['category']:
            bulletins = bulletins.filter(category=form.cleaned_data['category'])

    return render(request, "bulletin_board/bulletin_list.html", {
        'form': form,
        'object_list': bulletins,
    })