# -*- coding: UTF-8 -*-
from django import forms
from django.utils.translation import ugettext_lazy as _

from models import Genre
from models import Director
from models import Actor
from models import RATING_CHOICES


class MovieFilterForm(forms.Form):
    genre = forms.ModelChoiceField(
        label=_("Gatunek"),
        required=False,
        queryset=Genre.objects.all(),
    )
    director = forms.ModelChoiceField(
        label=_(u"Reżyser"),
        required=False,
        queryset=Director.objects.all(),
    )
    actor = forms.ModelChoiceField(
        label=_("Aktor"),
        required=False,
        queryset=Actor.objects.all(),
    )
    rating = forms.ChoiceField(
        label=_("Ocena"),
        required=False,
        choices=RATING_CHOICES,
    )
