# -*- coding: UTF-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _


class CV(models.Model):
    first_name = models.CharField(_(u"Imi"), max_length=40)
    last_name = models.CharField(_(u"Nazwisko"), max_length=40)
    email = models.EmailField(_("E-mail"))

    def __unicode__(self):
        return self.first_name + " " + self.last_name

class Experience(models.Model):
    cv = models.ForeignKey(CV)
    from_date = models.DateField(_("Od"))
    till_date = models.DateField(_("Do"), null=True, blank=True)
    company = models.CharField(_("Firma"), max_length=100)
    position = models.CharField(_("Stanowisko"), max_length=100)
    skills = models.TextField(_(u"Zdobyte umiejtnoci"), blank=True)

    def __unicode__(self):
        till = _(u"dziś")
        if self.till_date:
            till = self.till_date.strftime('%m/%Y')
        return _(u"%(from)s-%(till)s %(position)s w firmie %(company)s") % {
            'from': self.from_date.strftime('%m/%Y'),
            'till': till,
            'position': self.position,
            'company': self.company,
        }
    class Meta:
        ordering = ("-from_date",)
