unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, Buttons;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    BitBtn1: TBitBtn;
    procedure StringGrid1SetEditText(Sender: TObject; ACol, ARow: Integer;
      const Value: string);
    procedure StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
   punkty:integer;{ Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.BitBtn1Click(Sender: TObject);
var i:integer;
begin
   with Stringgrid1 do
   begin
     for i := 1 to 4 do Cells[1,i]:=InttoStr(Random(65));
     Repaint;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var i:integer;
begin
   //okrelenie szerokoci tabeli i kolumn
   with Stringgrid1 do
   begin
     Options:=Options+[goColSizing];
     Width:=230;
     ColWidths[0]:=100;
     ColWidths[1]:=70;
     ColWidths[2]:=50;
   end;

   Randomize;
   with Stringgrid1 do
   begin
     Cells[0,0]:='Imi';
     Cells[0,1]:='Piotr';
     Cells[0,2]:='Ala';
     Cells[0,3]:='Adam';
     Cells[0,4]:='Ola';
     Cells[1,0]:='Punkty';
     Cells[2,0]:='Pe';
     Cells[2,1]:='m';
     Cells[2,2]:='k';
     Cells[2,3]:='m';
     Cells[2,4]:='k';
     for i := 1 to 4 do Cells[1,i]:=InttoStr(Random(65));
   end;
   //ta instrukcja jest potrzebna do wyswietlenia napisu w dwch wierszach w Delphi7
   BitBtn1.Caption:='Wypenij tabel i zmie kolory wierszy w zalenoci od liczby punktw';
end;

procedure TForm1.StringGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var s:string;
begin
      //wiersz tytuowy pozostaje bez zmian
      if ARow=0 then exit;

      punkty:=StrtoInt(Stringgrid1.Cells[1,ARow]);
       // jesli wiek>35 to wiersz ty
      if (punkty > 35) then StringGrid1.Canvas.Brush.Color := clYellow
      else
      //w przeciwnym razie czerwony
      StringGrid1.Canvas.Brush.Color := clRed;

      //wypenienie komorki tabeli wybranym wczeniej kolorem
      StringGrid1.Canvas.FillRect(Rect);

      //wypenienie zasonio napis, wiec piszemy go na nowo
      s := StringGrid1.Cells[ACol, ARow];
      StringGrid1.Canvas.TextOut(Rect.Left + 2, Rect.Top + 2, s);
end;

procedure TForm1.StringGrid1SetEditText(Sender: TObject; ACol, ARow: Integer;
  const Value: string);
begin
  //przerysowanie tabeli po wprowadzeniu wartoci z klawiatury
  if Stringgrid1.Cells[ACol,ARow]<>'' then StringGrid1.Repaint;
end;

end.
