#!/usr/bin/perl -w
#
# ssiparser.cgi - prosta procedura obslugi do analizy wirtualnych wstawek SSI

require 5.001;

MAIN:
{
  print "Content-type: text/html\n\n";

  # Ta instrukcja obsluguje wywolanie procedury poprzez '/cgi/action.cgi?url='
  # zamiast '/cgi/action.cgi'. Niektore serwery uzywaja otoczki, ktore zastepuja
  # wartosci PATH_INFO i PATH_TRANSLATED, zatem musimy
  # ustawic QUERY_STRING by przetworzyc '?url=' zamiast pobrania zadanego
  # URL do procedury obslugi.
  if ($ENV{'QUERY_STRING'} && $ENV{'QUERY_STRING'}=~/^url=([^?]*)/) {
    $ENV{'PATH_INFO'}=$1;
    $ENV{'PATH_TRANSLATED'}=$ENV{'DOCUMENT_ROOT'}.$1;
  }

  # Pobierz tekst do przetworzenie
  my $textref=Read($ENV{'PATH_TRANSLATED'});

  # przetwarza ten tekst
  ProcessSSI($textref);
  # i go drukuje
  print $$textref;
}

# odczyt z pliku
sub Read {
  open(FILE,shift) || do { print "Pliku nie znaleziono\n"; exit; };
  undef $/; # usuwa definicje ogranicznika wiersza by wczytac plik w calosci
  my $text=<FILE>;
  close(FILE);
  $/="\n"; # przywraca ogranicznik $/

  return \$text;
}

# wykonuje wstawienia SSI
sub ProcessSSI {
  my $textref=shift;

  # dopasowanie wszystkich znacznikow SSI
  # zastepuje kazdy znacznik zdefiniowanym lancuchem
  while ($$textref=~s/<!--\#(\w+)\s+(\w+)=(?:'|")(.*?)(?:"|')-->/INCLUDE/s) {
    if ($1 eq 'include') {
      if ($2 eq 'virtual') {
        # wyznacza polozenie wlaczanego pliku
        my $file=$ENV{'DOCUMENT_ROOT'}.$3;
        # jesli to plik wykonywalny - uruchamia go, jesli nie - wlacza
        if (-x $file) {
          # zastepuje zdefiniowany lancuch wydrukiem z pliku,
          # usuwajac naglowek Content
          my $include=`$file`;
          $include=~/^\s*Content-type:\s+text\/html\s*/gs &&
          $$textref=~s/INCLUDE/substr $include,pos($include)/es;
        } else {
        # zastepuje zdefiniowany lancuch przez zawartosc pliku
        my $incref=Read($file);
        $$textref=~s/INCLUDE/$$incref/s;
        }
      }
    }
  }
}
