#!/usr/bin/perl -Tw
#
# capture.cgi - przechwytuje zmienne srodowiskowe i tworzy skrypt powloki

use CGI;
use CGI::Carp;
use strict;

my $cgi=new CGI;

# nazwa pliku do zapisania zmiennych srodowiskowych wpisana do kodu. Katalog dla
# tego pliku musi miec uprawnienia do zapisu przez uzykownika HTTP ('nobody')
my $scriptfile="/usr/local/apache/writable/env_script";

print $cgi->header();
print $cgi->start_html("Zmienne Srodowiskowe");
open(SCRIPT,"> $scriptfile") || do {
  print $cgi->h1("Nie mozna otworzyc pliku do zapisu: $!");
  print $cgi->end_html();
  die "Blad otwarcia pliku $scriptfile: $!";
};
print $cgi->h1("Zapis zmiennych srodowiskowych do $scriptfile");

flock(SCRIPT,1); # blokada pliku do zapisu

print "<ul>";
foreach (sort keys %ENV) {
  print "<li>$_ => $ENV{$_}";
  print SCRIPT "$_=\"".CGI::escape($ENV{$_})."\"; export $_\n";
}
print "</ul>\n";

flock(SCRIPT,8); # zwolnienie blokady pliku
close(SCRIPT);

print $cgi->end_html();