package Apache::AuthFileAuthenticator;
use strict;

use Apache::Constants qw(OK AUTH_REQUIRED SERVER_ERROR);

# repozytorium danych uzytkownik-password, dla poszczegolnych lokalizacji
my %locations={};

# szukaj, laduj, analizuj i buforuj info autoryzacyjne dla danej lokalizacji
sub get_config {
    my ($r,$location)=@_;

    # nie mona uwierzytelnic poza kontenerem
    unless ($location) {
        $r->note("Nie mozna uzyc __PACKAGE__ poza kontenerem");
        return SERVER_ERROR;
    }

    # czy to juz mamy?
    if (exists $locations{$location}) {
        return $locations{$location};
    }

    # pobierz plik konfiguracyjny uwierzytelniania: "PerlSetVar AuthFile <nazwa-pliku>"
    my $authfile=$r->dir_config->get("AuthFile");

    # otwiera plik lub zglasza blad
    unless (open USERS,$authfile) {
        $r->note("Fiasko otwarcia pliku '$authfile': $!");
        return SERVER_ERROR;
    }

    # przeczytaj wpisy uytkownik:haslo
    my %password;
    while (<USERS>) {
        chomp; #usun konczace znaki LF
        my ($user,$cryptpw)=split /:/;
        $password{$user}=$cryptpw;
    }
    close USERS;

    # zapisz liste hasel w tablicy asocjacyjnej dla poszczegolnych lokalizacji
    $locations{$location}=\%password;

    # zwraca informacje o hasle dla lokalizacji
    return $locations{$location};
}

sub handler {
    my $r=shift;

    # pobierz informacje dla uwierzytelnienia podstawowego
    my $user=$r->connection->user;
    my ($result,$sent_password)=$r->get_basic_auth_pw;
    return $result if $result!=OK;

    # szukaj informacji autoryzacyjnej w tej lokalizacji
    my $passwords=get_config($r,$r->location);

    if (defined($sent_password) and defined($user) 
                                and exists $passwords->{$user}) {
        if (crypt $sent_password,$passwords->{$user}) {
            # sprawdzenie hasla
            return OK;
        } else {
            # zle haslo
            return AUTH_REQUIRED;
        }
    } else {
        return AUTH_REQUIRED;
    }
}

1;
