# generuje na biezaco hosty wirtualne z wykorzystaniem Perla
<Perl>
#!/usr/bin/perl -w
#line <n>
# Powyzsze wraz z __END__ u dolu pozwala na sprawdzenie
# skladni tego bloku za pomoca polecenia 'perl -cx httpd.conf'. Zmien '<n>' w
# '#line <n>' na numer wiersza w httpd.conf, gdzie blok Perla faktycznie si zaczyna

# Definiuje kilka zmiennych lokalnych. Sa deklarowane jako zmienne lokalne, zatem
# Apache ich nie widzi i nie probuje interpretowac jako dyrektyw konfiguracyjnych
local ($ip,$host,$admin,$vroot,$aliases);
local ($directive,$args);

# Otwiera plik z informacja o hostach wirtualnych
open (FILE,"/usr/local/apache139/conf/vhosts.conf");

# Pobiera wiersze z pliku pojedynczo
while (<FILE>) {
  # pomija komentarze i puste wiersze
  next if /^\s*(#|$)/;

  # Jesli wiersz rozpoczyna si od numeru to jest to IP nowego hosta
  if (/^\d+/) {

    # Pozyskuje zasadnicze wartosci dla hosta wirtualnego i dokonuje ich przypisania
    ($ip,$host,$admin,$vroot,$aliases)=split /\s*,\s*/,$_;
    $VirtualHost{$ip}={
      ServerName => $host,
      ServerAdmin => $admin, 
      DocumentRoot => "/home/www/".$vroot,
      ErrorLog => "logs/".$host."_error",
      TransferLog => "logs/".$host."_log"
    };
    
    # Jesli sa dane jakies aliasy, przypisz je do dyrektywy ServerAlias
    $VirtualHost{$ip}{ServerAlias}=$aliases if $aliases;

    # Jesli adres IP ma dolaczony numer portu, dodaj odpowiednia dyrektywe Port
    $VirtualHost{$ip}{Port}=$1 if ($ip=~/:(\d+)$/); 

  # W przeciwnym razie, jest to dowolna dodatkowa dyrektywa dla rzeczonego hosta
  } elsif ($ip) { 
    # Zauwazmy, ze to obsluguje tylko proste dyrektywy, a nie kontenery
    ($directive,$args)=split / /,$_,2; 
    $VirtualHost{$ip}{$directive}=$args;
  }
}

# wszystko gotowe
close (FILE); 

# mowi poleceniu 'perl -cx' by zakonczyc sprawdzanie skladni
__END__
# wracamy do httpd.conf
</Perl>
