/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Build;
import android.support.design.R;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.MathUtils;
import android.support.v4.view.ViewCompat;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Interpolator;

final class CollapsingTextHelper {
    private static final boolean USE_SCALING_TEXTURE = Build.VERSION.SDK_INT < 18;
    private static final boolean DEBUG_DRAW = false;
    private static final Paint DEBUG_DRAW_PAINT = null;
    private final View mView;
    private float mExpandedFraction;
    private final Rect mExpandedBounds;
    private final Rect mCollapsedBounds;
    private int mExpandedTextVerticalGravity = 16;
    private int mCollapsedTextVerticalGravity = 16;
    private float mExpandedTextSize;
    private float mCollapsedTextSize;
    private int mExpandedTextColor;
    private int mCollapsedTextColor;
    private float mExpandedTop;
    private float mCollapsedTop;
    private CharSequence mText;
    private CharSequence mTextToDraw;
    private float mTextWidth;
    private boolean mUseTexture;
    private Bitmap mExpandedTitleTexture;
    private Paint mTexturePaint;
    private float mTextureAscent;
    private float mTextureDescent;
    private float mCurrentLeft;
    private float mCurrentRight;
    private float mCurrentTop;
    private float mScale;
    private float mCurrentTextSize;
    private final TextPaint mTextPaint;
    private Interpolator mPositionInterpolator;
    private Interpolator mTextSizeInterpolator;

    public CollapsingTextHelper(View view) {
        this.mView = view;
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setAntiAlias(true);
        this.mCollapsedBounds = new Rect();
        this.mExpandedBounds = new Rect();
    }

    void setTextSizeInterpolator(Interpolator interpolator) {
        this.mTextSizeInterpolator = interpolator;
        this.recalculate();
    }

    void setPositionInterpolator(Interpolator interpolator) {
        this.mPositionInterpolator = interpolator;
        this.recalculate();
    }

    void setExpandedTextSize(float textSize) {
        if (this.mExpandedTextSize != textSize) {
            this.mExpandedTextSize = textSize;
            this.recalculate();
        }
    }

    void setCollapsedTextSize(float textSize) {
        if (this.mCollapsedTextSize != textSize) {
            this.mCollapsedTextSize = textSize;
            this.recalculate();
        }
    }

    void setCollapsedTextColor(int textColor) {
        if (this.mCollapsedTextColor != textColor) {
            this.mCollapsedTextColor = textColor;
            this.recalculate();
        }
    }

    void setExpandedTextColor(int textColor) {
        if (this.mExpandedTextColor != textColor) {
            this.mExpandedTextColor = textColor;
            this.recalculate();
        }
    }

    void setExpandedBounds(int left, int top, int right, int bottom) {
        this.mExpandedBounds.set(left, top, right, bottom);
        this.recalculate();
    }

    void setCollapsedBounds(int left, int top, int right, int bottom) {
        this.mCollapsedBounds.set(left, top, right, bottom);
        this.recalculate();
    }

    void setExpandedTextVerticalGravity(int gravity) {
        if (this.mExpandedTextVerticalGravity != (gravity &= 0x70)) {
            this.mExpandedTextVerticalGravity = gravity;
            this.recalculate();
        }
    }

    void setCollapsedTextVerticalGravity(int gravity) {
        if (this.mCollapsedTextVerticalGravity != (gravity &= 0x70)) {
            this.mCollapsedTextVerticalGravity = gravity;
            this.recalculate();
        }
    }

    void setCollapsedTextAppearance(int resId) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(resId, R.styleable.TextAppearance);
        if (a.hasValue(R.styleable.TextAppearance_android_textColor)) {
            this.mCollapsedTextColor = a.getColor(R.styleable.TextAppearance_android_textColor, 0);
        }
        if (a.hasValue(R.styleable.TextAppearance_android_textSize)) {
            this.mCollapsedTextSize = a.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, 0);
        }
        a.recycle();
        this.recalculate();
    }

    void setExpandedTextAppearance(int resId) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(resId, R.styleable.TextAppearance);
        if (a.hasValue(R.styleable.TextAppearance_android_textColor)) {
            this.mExpandedTextColor = a.getColor(R.styleable.TextAppearance_android_textColor, 0);
        }
        if (a.hasValue(R.styleable.TextAppearance_android_textSize)) {
            this.mExpandedTextSize = a.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, 0);
        }
        a.recycle();
        this.recalculate();
    }

    void setExpansionFraction(float fraction) {
        if ((fraction = MathUtils.constrain(fraction, 0.0f, 1.0f)) != this.mExpandedFraction) {
            this.mExpandedFraction = fraction;
            this.calculateOffsets();
        }
    }

    float getExpansionFraction() {
        return this.mExpandedFraction;
    }

    float getCollapsedTextSize() {
        return this.mCollapsedTextSize;
    }

    float getExpandedTextSize() {
        return this.mExpandedTextSize;
    }

    private void calculateOffsets() {
        float fraction = this.mExpandedFraction;
        this.mCurrentLeft = CollapsingTextHelper.interpolate(this.mExpandedBounds.left, this.mCollapsedBounds.left, fraction, this.mPositionInterpolator);
        this.mCurrentTop = CollapsingTextHelper.interpolate(this.mExpandedTop, this.mCollapsedTop, fraction, this.mPositionInterpolator);
        this.mCurrentRight = CollapsingTextHelper.interpolate(this.mExpandedBounds.right, this.mCollapsedBounds.right, fraction, this.mPositionInterpolator);
        this.setInterpolatedTextSize(CollapsingTextHelper.interpolate(this.mExpandedTextSize, this.mCollapsedTextSize, fraction, this.mTextSizeInterpolator));
        if (this.mCollapsedTextColor != this.mExpandedTextColor) {
            this.mTextPaint.setColor(CollapsingTextHelper.blendColors(this.mExpandedTextColor, this.mCollapsedTextColor, fraction));
        } else {
            this.mTextPaint.setColor(this.mCollapsedTextColor);
        }
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
    }

    private void calculateBaselines() {
        float textOffset;
        float textHeight;
        this.mTextPaint.setTextSize(this.mCollapsedTextSize);
        switch (this.mCollapsedTextVerticalGravity) {
            case 80: {
                this.mCollapsedTop = this.mCollapsedBounds.bottom;
                break;
            }
            case 48: {
                this.mCollapsedTop = (float)this.mCollapsedBounds.top - this.mTextPaint.ascent();
                break;
            }
            default: {
                textHeight = this.mTextPaint.descent() - this.mTextPaint.ascent();
                textOffset = textHeight / 2.0f - this.mTextPaint.descent();
                this.mCollapsedTop = (float)this.mCollapsedBounds.centerY() + textOffset;
            }
        }
        this.mTextPaint.setTextSize(this.mExpandedTextSize);
        switch (this.mExpandedTextVerticalGravity) {
            case 80: {
                this.mExpandedTop = this.mExpandedBounds.bottom;
                break;
            }
            case 48: {
                this.mExpandedTop = (float)this.mExpandedBounds.top - this.mTextPaint.ascent();
                break;
            }
            default: {
                textHeight = this.mTextPaint.descent() - this.mTextPaint.ascent();
                textOffset = textHeight / 2.0f - this.mTextPaint.descent();
                this.mExpandedTop = (float)this.mExpandedBounds.centerY() + textOffset;
            }
        }
        this.mTextureAscent = this.mTextPaint.ascent();
        this.mTextureDescent = this.mTextPaint.descent();
        this.clearTexture();
    }

    public void draw(Canvas canvas) {
        int saveCount = canvas.save();
        if (this.mTextToDraw != null) {
            float ascent;
            boolean isRtl = ViewCompat.getLayoutDirection((View)this.mView) == 1;
            float x = isRtl ? this.mCurrentRight : this.mCurrentLeft;
            float y = this.mCurrentTop;
            boolean drawTexture = this.mUseTexture && this.mExpandedTitleTexture != null;
            this.mTextPaint.setTextSize(this.mCurrentTextSize);
            if (drawTexture) {
                ascent = this.mTextureAscent * this.mScale;
                float descent = this.mTextureDescent * this.mScale;
            } else {
                ascent = this.mTextPaint.ascent() * this.mScale;
                float descent = this.mTextPaint.descent() * this.mScale;
            }
            if (drawTexture) {
                y += ascent;
            }
            if (this.mScale != 1.0f) {
                canvas.scale(this.mScale, this.mScale, x, y);
            }
            if (isRtl) {
                x -= this.mTextWidth;
            }
            if (drawTexture) {
                canvas.drawBitmap(this.mExpandedTitleTexture, x, y, this.mTexturePaint);
            } else {
                canvas.drawText(this.mTextToDraw, 0, this.mTextToDraw.length(), x, y, (Paint)this.mTextPaint);
            }
        }
        canvas.restoreToCount(saveCount);
    }

    private void setInterpolatedTextSize(float textSize) {
        float newTextSize;
        float availableWidth;
        if (this.mText == null) {
            return;
        }
        boolean updateDrawText = false;
        if (CollapsingTextHelper.isClose(textSize, this.mCollapsedTextSize)) {
            availableWidth = this.mCollapsedBounds.width();
            newTextSize = this.mCollapsedTextSize;
            this.mScale = 1.0f;
        } else {
            availableWidth = this.mExpandedBounds.width();
            newTextSize = this.mExpandedTextSize;
            this.mScale = CollapsingTextHelper.isClose(textSize, this.mExpandedTextSize) ? 1.0f : textSize / this.mExpandedTextSize;
        }
        if (availableWidth > 0.0f) {
            updateDrawText = this.mCurrentTextSize != newTextSize;
            this.mCurrentTextSize = newTextSize;
        }
        if (this.mTextToDraw == null || updateDrawText) {
            this.mTextPaint.setTextSize(this.mCurrentTextSize);
            CharSequence title = TextUtils.ellipsize((CharSequence)this.mText, (TextPaint)this.mTextPaint, (float)availableWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            if (this.mTextToDraw == null || !this.mTextToDraw.equals(title)) {
                this.mTextToDraw = title;
            }
            this.mTextWidth = this.mTextPaint.measureText(this.mTextToDraw, 0, this.mTextToDraw.length());
        }
        boolean bl = this.mUseTexture = USE_SCALING_TEXTURE && this.mScale != 1.0f;
        if (this.mUseTexture) {
            this.ensureExpandedTexture();
        }
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
    }

    private void ensureExpandedTexture() {
        if (this.mExpandedTitleTexture != null || this.mExpandedBounds.isEmpty() || TextUtils.isEmpty((CharSequence)this.mTextToDraw)) {
            return;
        }
        this.mTextPaint.setTextSize(this.mExpandedTextSize);
        this.mTextPaint.setColor(this.mExpandedTextColor);
        int w = Math.round(this.mTextPaint.measureText(this.mTextToDraw, 0, this.mTextToDraw.length()));
        int h = Math.round(this.mTextPaint.descent() - this.mTextPaint.ascent());
        this.mTextWidth = w;
        if (w <= 0 && h <= 0) {
            return;
        }
        this.mExpandedTitleTexture = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(this.mExpandedTitleTexture);
        c.drawText(this.mTextToDraw, 0, this.mTextToDraw.length(), 0.0f, (float)h - this.mTextPaint.descent(), (Paint)this.mTextPaint);
        if (this.mTexturePaint == null) {
            this.mTexturePaint = new Paint();
            this.mTexturePaint.setAntiAlias(true);
            this.mTexturePaint.setFilterBitmap(true);
        }
    }

    private void recalculate() {
        if (ViewCompat.isLaidOut((View)this.mView)) {
            this.calculateBaselines();
            this.calculateOffsets();
        }
    }

    void setText(CharSequence text) {
        if (text == null || !text.equals(this.mText)) {
            this.mText = text;
            this.clearTexture();
            this.recalculate();
        }
    }

    CharSequence getText() {
        return this.mText;
    }

    private void clearTexture() {
        if (this.mExpandedTitleTexture != null) {
            this.mExpandedTitleTexture.recycle();
            this.mExpandedTitleTexture = null;
        }
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.recalculate();
    }

    private static boolean isClose(float value, float targetValue) {
        return Math.abs(value - targetValue) < 0.001f;
    }

    int getExpandedTextColor() {
        return this.mExpandedTextColor;
    }

    int getCollapsedTextColor() {
        return this.mCollapsedTextColor;
    }

    private static int blendColors(int color1, int color2, float ratio) {
        float inverseRatio = 1.0f - ratio;
        float a = (float)Color.alpha((int)color1) * inverseRatio + (float)Color.alpha((int)color2) * ratio;
        float r = (float)Color.red((int)color1) * inverseRatio + (float)Color.red((int)color2) * ratio;
        float g = (float)Color.green((int)color1) * inverseRatio + (float)Color.green((int)color2) * ratio;
        float b = (float)Color.blue((int)color1) * inverseRatio + (float)Color.blue((int)color2) * ratio;
        return Color.argb((int)((int)a), (int)((int)r), (int)((int)g), (int)((int)b));
    }

    private static float interpolate(float startValue, float endValue, float fraction, Interpolator interpolator) {
        if (interpolator != null) {
            fraction = interpolator.getInterpolation(fraction);
        }
        return AnimationUtils.lerp(startValue, endValue, fraction);
    }

    static {
        if (DEBUG_DRAW_PAINT != null) {
            DEBUG_DRAW_PAINT.setAntiAlias(true);
            DEBUG_DRAW_PAINT.setColor(-65281);
        }
    }
}

