DELIMITER //
-- START:create
CREATE PROCEDURE WyszukiwanieBledow(slowo_kluczowe VARCHAR(40))
BEGIN
 SET @slowo_kluczowe = slowo_kluczowe;

 PREPARE s1 FROM 'SELECT MAX(id_slowa_kluczowego) INTO @k FROM SlowaKluczowe -- <callout id="code.search.getk"/>
 WHERE slowo_kluczowe = ?';
 EXECUTE s1 USING @slowo_kluczowe;
 DEALLOCATE PREPARE s1;

 IF (@k IS NULL) THEN
 PREPARE s2 FROM 'INSERT INTO SlowaKluczowe (slowo_kluczowe) VALUES (?)'; -- <callout id="code.search.insert1"/>
 EXECUTE s2 USING @slowo_kluczowe;
 DEALLOCATE PREPARE s2;
 SELECT LAST_INSERT_ID() INTO @k; -- <callout id="code.search.lastid"/>

 PREPARE s3 FROM 'INSERT INTO BledySlowaKluczowe (id_bledu, id_slowa_kluczowego) -- <callout id="code.search.insert2"/>
 SELECT id_bledu, ? FROM Bledy
 WHERE podsumowanie REGEXP CONCAT('' [[:<:]]'' , ?, '' [[:>:]]'')
	OR opis REGEXP CONCAT('' [[:<:]]'' , ?, '' [[:>]]'')';
 EXECUTE s3 USING @k, @slowo_kluczowe, @slowo_kluczowe;
 DEALLOCATE PREPARE s3;
 END IF;

 PREPARE s4 FROM 'SELECT b.* FROM Bledy b -- <callout id="code.search.select"/>
 JOIN BledySlowaKluczowe k USING (id_bledu)
 WHERE k.id_slowa_kluczowego = ?';
 EXECUTE s4 USING @k;
 DEALLOCATE PREPARE s4;
END
-- END:create
//
DELIMITER ;
-- START:call
CALL WyszukiwanieBledow('awaria');
-- END:call
