/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.text.TextUtils;
import com.google.analytics.tracking.android.Item;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Transaction {
    private final String transactionId;
    private final String affiliation;
    private final long totalCostInMicros;
    private final long totalTaxInMicros;
    private final long shippingCostInMicros;
    private final String currencyCode;
    private final Map<String, Item> items;

    private Transaction(Builder builder) {
        this.transactionId = builder.transactionId;
        this.totalCostInMicros = builder.totalCostInMicros;
        this.affiliation = builder.affiliation;
        this.totalTaxInMicros = builder.totalTaxInMicros;
        this.shippingCostInMicros = builder.shippingCostInMicros;
        this.currencyCode = builder.currencyCode;
        this.items = new HashMap<String, Item>();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getAffiliation() {
        return this.affiliation;
    }

    public long getTotalCostInMicros() {
        return this.totalCostInMicros;
    }

    public long getTotalTaxInMicros() {
        return this.totalTaxInMicros;
    }

    public long getShippingCostInMicros() {
        return this.shippingCostInMicros;
    }

    String getCurrencyCode() {
        return this.currencyCode;
    }

    public void addItem(Item item) {
        this.items.put(item.getProductSKU(), item);
    }

    public List<Item> getItems() {
        return new ArrayList<Item>(this.items.values());
    }

    public static class Builder {
        private final String transactionId;
        private String affiliation = null;
        private final long totalCostInMicros;
        private long totalTaxInMicros = 0L;
        private long shippingCostInMicros = 0L;
        private String currencyCode = null;

        public Builder(String transactionId, long totalCostInMicros) {
            if (TextUtils.isEmpty((CharSequence)transactionId)) {
                throw new IllegalArgumentException("transactionId must not be empty or null");
            }
            this.transactionId = transactionId;
            this.totalCostInMicros = totalCostInMicros;
        }

        public Builder setAffiliation(String affiliation) {
            this.affiliation = affiliation;
            return this;
        }

        public Builder setTotalTaxInMicros(long totalTaxInMicros) {
            this.totalTaxInMicros = totalTaxInMicros;
            return this;
        }

        public Builder setShippingCostInMicros(long shippingCostInMicros) {
            this.shippingCostInMicros = shippingCostInMicros;
            return this;
        }

        Builder setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Transaction build() {
            return new Transaction(this);
        }
    }
}

