/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import com.google.analytics.tracking.android.AnalyticsStore;
import com.google.analytics.tracking.android.AnalyticsStoreStateListener;
import com.google.analytics.tracking.android.Dispatcher;
import com.google.analytics.tracking.android.FutureApis;
import com.google.analytics.tracking.android.GAServiceManager;
import com.google.analytics.tracking.android.Hit;
import com.google.analytics.tracking.android.HitBuilder;
import com.google.analytics.tracking.android.HttpClientFactory;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.NoopDispatcher;
import com.google.analytics.tracking.android.SimpleNetworkDispatcher;
import com.google.android.gms.analytics.internal.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class PersistentAnalyticsStore
implements AnalyticsStore {
    static final String BACKEND_LIBRARY_VERSION = "-s1";
    static final long TIME_PER_TOKEN_MILLIS = 2000L;
    static final long MAX_TOKENS = 120000L;
    private long tokens = 120000L;
    private long lastTrackTime;
    private boolean throttlingEnabled = true;
    private static final String HIT_ID = "hit_id";
    private static final String HIT_STRING = "hit_string";
    private static final String HIT_TIME = "hit_time";
    private static final String HIT_URL = "hit_url";
    private static final String HITS_TABLE = "hits2";
    private static final String CREATE_HITS_TABLE = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string");
    private static final String DATABASE_FILENAME = "google_analytics_v2.db";
    private final AnalyticsDatabaseHelper dbHelper;
    private volatile Dispatcher dispatcher;
    private final AnalyticsStoreStateListener listener;
    private final Context context;
    private final String databaseName;
    private long lastDeleteStaleHitsTime;

    PersistentAnalyticsStore(AnalyticsStoreStateListener listener, Context ctx) {
        this(listener, ctx, DATABASE_FILENAME);
    }

    PersistentAnalyticsStore(AnalyticsStoreStateListener listener, Context ctx, String databaseName) {
        this.context = ctx.getApplicationContext();
        this.databaseName = databaseName;
        this.listener = listener;
        this.dbHelper = new AnalyticsDatabaseHelper(this.context, this.databaseName);
        this.dispatcher = new SimpleNetworkDispatcher(this, this.createDefaultHttpClientFactory(), this.context);
        this.lastDeleteStaleHitsTime = 0L;
    }

    private HttpClientFactory createDefaultHttpClientFactory() {
        return new HttpClientFactory(){

            @Override
            public HttpClient newInstance() {
                return new DefaultHttpClient();
            }
        };
    }

    @Override
    public void setDispatch(boolean dispatch) {
        this.dispatcher = dispatch ? new SimpleNetworkDispatcher(this, this.createDefaultHttpClientFactory(), this.context) : new NoopDispatcher();
    }

    void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public void clearHits() {
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for clearHits");
        if (db != null) {
            db.delete(HITS_TABLE, null, null);
            this.listener.reportStoreIsEmpty(true);
        }
    }

    @Override
    public void putHit(Map<String, String> wireFormatParams, long hitTimeInMilliseconds, String path, Collection<Command> commands) {
        this.deleteStaleHits();
        if (!this.tokensAvailable()) {
            return;
        }
        this.fillVersionParametersIfNecessary(wireFormatParams, commands);
        this.removeOldHitIfFull();
        this.writeHitToDatabase(wireFormatParams, hitTimeInMilliseconds, path);
    }

    private void fillVersionParametersIfNecessary(Map<String, String> wireFormatParams, Collection<Command> commands) {
        for (Command command : commands) {
            if (!command.getId().equals("appendVersion")) continue;
            String clientVersion = command.getValue();
            this.storeVersion(wireFormatParams, command.getUrlParam(), clientVersion);
            break;
        }
    }

    private void storeVersion(Map<String, String> wireFormatParams, String versionUrlParam, String clientVersion) {
        String version = clientVersion;
        version = clientVersion == null ? BACKEND_LIBRARY_VERSION : clientVersion;
        if (versionUrlParam != null) {
            wireFormatParams.put(versionUrlParam, version);
        }
    }

    private void removeOldHitIfFull() {
        int hitsOverLimit = this.getNumStoredHits() - 2000 + 1;
        if (hitsOverLimit > 0) {
            List<Hit> hitsToDelete = this.peekHits(hitsOverLimit);
            Log.wDebug("Store full, deleting " + hitsToDelete.size() + " hits to make room");
            this.deleteHits(hitsToDelete);
        }
    }

    private void writeHitToDatabase(Map<String, String> hit, long hitTimeInMilliseconds, String path) {
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for putHit");
        if (db == null) {
            return;
        }
        ContentValues content = new ContentValues();
        content.put(HIT_STRING, PersistentAnalyticsStore.generateHitString(hit));
        content.put(HIT_TIME, Long.valueOf(hitTimeInMilliseconds));
        if (path == null) {
            path = "http://www.google-analytics.com/collect";
        }
        if (path.length() == 0) {
            Log.w("empty path: not sending hit");
            return;
        }
        content.put(HIT_URL, path);
        try {
            db.insert(HITS_TABLE, null, content);
            this.listener.reportStoreIsEmpty(false);
        }
        catch (SQLiteException e) {
            Log.w("Error storing hit");
        }
    }

    public static String generateHitString(Map<String, String> urlParams) {
        ArrayList<String> keyAndValues = new ArrayList<String>(urlParams.size());
        for (Map.Entry<String, String> entry : urlParams.entrySet()) {
            keyAndValues.add(entry.getKey() + "=" + HitBuilder.encode(entry.getValue()));
        }
        return TextUtils.join((CharSequence)"&", keyAndValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Hit> peekHits(int maxHits) {
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for peekHits");
        if (db == null) {
            return new ArrayList<Hit>();
        }
        Cursor cursor = null;
        CursorWindow hits = new ArrayList();
        try {
            cursor = db.query(HITS_TABLE, new String[]{HIT_ID, HIT_TIME, HIT_URL}, null, null, null, null, String.format("%s ASC, %s ASC", HIT_URL, HIT_ID), Integer.toString(maxHits));
            hits = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    Hit hit = new Hit(null, cursor.getLong(0), cursor.getLong(1));
                    hit.setHitUrl(cursor.getString(2));
                    hits.add(hit);
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException e) {
            Log.w("error in peekHits fetching hitIds: " + e.getMessage());
            ArrayList<Hit> arrayList = new ArrayList<Hit>();
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        int count = 0;
        try {
            CursorWindow cw;
            cursor = db.query(HITS_TABLE, new String[]{HIT_ID, HIT_STRING}, null, null, null, null, String.format("%s ASC", HIT_ID), Integer.toString(maxHits));
            if (cursor.moveToFirst()) {
                do {
                    if (cursor instanceof SQLiteCursor) {
                        cw = ((SQLiteCursor)cursor).getWindow();
                        if (cw.getNumRows() > 0) {
                            ((Hit)hits.get(count)).setHitString(cursor.getString(1));
                        } else {
                            Log.w("hitString for hitId " + ((Hit)hits.get(count)).getHitId() + " too large.  Hit will be deleted.");
                        }
                    } else {
                        ((Hit)hits.get(count)).setHitString(cursor.getString(1));
                    }
                    ++count;
                } while (cursor.moveToNext());
            }
            cw = hits;
            return cw;
        }
        catch (SQLiteException e) {
            Log.w("error in peekHits fetching hitString: " + e.getMessage());
            ArrayList<Hit> partialHits = new ArrayList<Hit>();
            boolean foundOneBadHit = false;
            for (Hit hit : hits) {
                if (TextUtils.isEmpty((CharSequence)hit.getHitParams())) {
                    if (foundOneBadHit) break;
                    foundOneBadHit = true;
                }
                partialHits.add(hit);
            }
            ArrayList<Hit> arrayList = partialHits;
            return arrayList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    void setLastDeleteStaleHitsTime(long timeInMilliseconds) {
        this.lastDeleteStaleHitsTime = timeInMilliseconds;
    }

    int deleteStaleHits() {
        long now = System.currentTimeMillis();
        if (now <= this.lastDeleteStaleHitsTime + 86400000L) {
            return 0;
        }
        this.lastDeleteStaleHitsTime = now;
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for deleteStaleHits");
        if (db == null) {
            return 0;
        }
        long lastGoodTime = System.currentTimeMillis() - 2592000000L;
        int rslt = db.delete(HITS_TABLE, "HIT_TIME < ?", new String[]{Long.toString(lastGoodTime)});
        this.listener.reportStoreIsEmpty(this.getNumStoredHits() == 0);
        return rslt;
    }

    public void deleteHits(Collection<Hit> hits) {
        if (hits == null) {
            throw new NullPointerException("hits cannot be null");
        }
        if (hits.isEmpty()) {
            return;
        }
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for deleteHit");
        if (db == null) {
            return;
        }
        String[] ids = new String[hits.size()];
        String whereClause = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(ids.length, "?")));
        int i = 0;
        for (Hit hit : hits) {
            ids[i++] = Long.toString(hit.getHitId());
        }
        try {
            db.delete(HITS_TABLE, whereClause, ids);
            this.listener.reportStoreIsEmpty(this.getNumStoredHits() == 0);
        }
        catch (SQLiteException e) {
            Log.w("Error deleting hit " + hits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumStoredHits() {
        int numStoredHits = 0;
        SQLiteDatabase db = this.getWritableDatabase("Error opening database for requestNumHitsPending");
        if (db == null) {
            return numStoredHits;
        }
        Cursor cursor = null;
        try {
            cursor = db.rawQuery("SELECT COUNT(*) from hits2", null);
            if (cursor.moveToFirst()) {
                numStoredHits = (int)cursor.getLong(0);
            }
        }
        catch (SQLiteException e) {
            Log.w("Error getting numStoredHits");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return numStoredHits;
    }

    @Override
    public void dispatch() {
        Log.vDebug("dispatch running...");
        if (!this.dispatcher.okToDispatch()) {
            return;
        }
        List<Hit> hits = this.peekHits(40);
        if (hits.isEmpty()) {
            Log.vDebug("...nothing to dispatch");
            this.listener.reportStoreIsEmpty(true);
            return;
        }
        int hitsDispatched = this.dispatcher.dispatchHits(hits);
        Log.vDebug("sent " + hitsDispatched + " of " + hits.size() + " hits");
        this.deleteHits(hits.subList(0, Math.min(hitsDispatched, hits.size())));
        if (hitsDispatched == hits.size() && this.getNumStoredHits() > 0) {
            GAServiceManager.getInstance().dispatch();
        }
    }

    @Override
    public void close() {
        try {
            this.dbHelper.getWritableDatabase().close();
        }
        catch (SQLiteException e) {
            Log.w("Error opening database for close");
            return;
        }
    }

    void setLastTrackTime(long lastTrackTime) {
        this.lastTrackTime = lastTrackTime;
    }

    void setTokens(long tokens) {
        this.tokens = tokens;
    }

    synchronized boolean tokensAvailable() {
        long timeElapsed;
        if (!this.throttlingEnabled) {
            return true;
        }
        long timeNow = System.currentTimeMillis();
        if (this.tokens < 120000L && (timeElapsed = timeNow - this.lastTrackTime) > 0L) {
            this.tokens = Math.min(120000L, this.tokens + timeElapsed);
        }
        this.lastTrackTime = timeNow;
        if (this.tokens >= 2000L) {
            this.tokens -= 2000L;
            return true;
        }
        Log.wDebug("Excessive tracking detected.  Tracking call ignored.");
        return false;
    }

    @Override
    public void setThrottlingEnabled(boolean throttlingEnabled) {
        this.throttlingEnabled = throttlingEnabled;
    }

    AnalyticsDatabaseHelper getHelper() {
        return this.dbHelper;
    }

    private SQLiteDatabase getWritableDatabase(String errorMessage) {
        SQLiteDatabase db = null;
        try {
            db = this.dbHelper.getWritableDatabase();
        }
        catch (SQLiteException e) {
            Log.w(errorMessage);
            return null;
        }
        return db;
    }

    class AnalyticsDatabaseHelper
    extends SQLiteOpenHelper {
        private boolean badDatabase;

        boolean isBadDatabase() {
            return this.badDatabase;
        }

        AnalyticsDatabaseHelper(Context context, String databaseName) {
            super(context, databaseName, null, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tablePresent(String table, SQLiteDatabase db) {
            Cursor cursor = null;
            try {
                cursor = db.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{table}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
            catch (SQLiteException e) {
                Log.w("error querying for table " + table);
                boolean bl = false;
                return bl;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.badDatabase) {
                throw new SQLiteException("Database creation failed");
            }
            return super.getWritableDatabase();
        }

        public void onOpen(SQLiteDatabase db) {
            try {
                if (!this.tablePresent(PersistentAnalyticsStore.HITS_TABLE, db)) {
                    db.execSQL(CREATE_HITS_TABLE);
                }
            }
            catch (SQLiteException e) {
                Log.w("Error on database open");
                this.badDatabase = true;
                return;
            }
        }

        public void onCreate(SQLiteDatabase db) {
            FutureApis.setOwnerOnlyReadWrite(db.getPath());
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

