/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.analytics.tracking.android.Analytics;
import com.google.analytics.tracking.android.Clock;
import com.google.analytics.tracking.android.ExceptionParser;
import com.google.analytics.tracking.android.ExceptionReporter;
import com.google.analytics.tracking.android.GAServiceManager;
import com.google.analytics.tracking.android.GoogleAnalytics;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.ParameterLoader;
import com.google.analytics.tracking.android.ParameterLoaderImpl;
import com.google.analytics.tracking.android.ServiceManager;
import com.google.analytics.tracking.android.Tracker;
import com.google.analytics.tracking.android.Transaction;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class EasyTracker {
    private static EasyTracker instance;
    static final int NUM_MILLISECONDS_TO_WAIT_FOR_OPEN_ACTIVITY = 1000;
    private boolean gaEnabled = false;
    private String gaTrackingId;
    private String gaAppName;
    private String gaAppVersion;
    private int gaDispatchPeriod = 1800;
    private boolean gaDebug;
    private Double gaSampleRate;
    private boolean gaAnonymizeIp;
    private boolean gaReportUncaughtExceptions;
    private Thread.UncaughtExceptionHandler handler;
    private boolean autoActivityTracking = false;
    private int activitiesActive = 0;
    private long gaSessionTimeout;
    private long lastOnStopTime;
    private Context gaContext;
    private final Map<String, String> activityNameMap = new HashMap<String, String>();
    private Tracker tracker = null;
    private ParameterLoader parameterFetcher;
    private Analytics ga;
    private ServiceManager serviceManager;
    private Clock clock = new Clock(){

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    };
    private Timer timer;
    private TimerTask timerTask;
    private boolean inForeground = false;

    private EasyTracker() {
    }

    public static EasyTracker getInstance() {
        if (instance == null) {
            instance = new EasyTracker();
        }
        return instance;
    }

    public static Tracker getTracker() {
        if (EasyTracker.getInstance().gaContext == null) {
            throw new IllegalStateException("You must call EasyTracker.getInstance().setContext(context) or startActivity(activity) before calling getTracker()");
        }
        return EasyTracker.getInstance().tracker;
    }

    boolean checkForNewSession() {
        return this.gaSessionTimeout == 0L || this.gaSessionTimeout > 0L && this.clock.currentTimeMillis() > this.lastOnStopTime + this.gaSessionTimeout;
    }

    private void loadParameters() {
        this.gaTrackingId = this.parameterFetcher.getString("ga_trackingId");
        if (TextUtils.isEmpty((CharSequence)this.gaTrackingId)) {
            this.gaTrackingId = this.parameterFetcher.getString("ga_api_key");
            if (TextUtils.isEmpty((CharSequence)this.gaTrackingId)) {
                Log.e("EasyTracker requested, but missing required ga_trackingId");
                this.tracker = new NoopTracker();
                return;
            }
        }
        this.gaEnabled = true;
        this.gaAppName = this.parameterFetcher.getString("ga_appName");
        this.gaAppVersion = this.parameterFetcher.getString("ga_appVersion");
        this.gaDebug = this.parameterFetcher.getBoolean("ga_debug");
        this.gaSampleRate = this.parameterFetcher.getDoubleFromString("ga_sampleFrequency");
        if (this.gaSampleRate == null) {
            this.gaSampleRate = new Double(this.parameterFetcher.getInt("ga_sampleRate", 100));
        }
        this.gaDispatchPeriod = this.parameterFetcher.getInt("ga_dispatchPeriod", 1800);
        this.gaSessionTimeout = this.parameterFetcher.getInt("ga_sessionTimeout", 30) * 1000;
        this.autoActivityTracking = this.parameterFetcher.getBoolean("ga_autoActivityTracking") || this.parameterFetcher.getBoolean("ga_auto_activity_tracking");
        this.gaAnonymizeIp = this.parameterFetcher.getBoolean("ga_anonymizeIp");
        this.gaReportUncaughtExceptions = this.parameterFetcher.getBoolean("ga_reportUncaughtExceptions");
        this.tracker = this.ga.getTracker(this.gaTrackingId);
        if (!TextUtils.isEmpty((CharSequence)this.gaAppName)) {
            Log.i("setting appName to " + this.gaAppName);
            this.tracker.setAppName(this.gaAppName);
        }
        if (this.gaAppVersion != null) {
            this.tracker.setAppVersion(this.gaAppVersion);
        }
        this.tracker.setAnonymizeIp(this.gaAnonymizeIp);
        this.tracker.setSampleRate(this.gaSampleRate);
        this.ga.setDebug(this.gaDebug);
        this.serviceManager.setDispatchPeriod(this.gaDispatchPeriod);
        if (this.gaReportUncaughtExceptions) {
            Thread.UncaughtExceptionHandler newHandler = this.handler;
            if (newHandler == null) {
                ExceptionReporter reporter = new ExceptionReporter(this.tracker, this.serviceManager, Thread.getDefaultUncaughtExceptionHandler());
                newHandler = reporter;
            }
            Thread.setDefaultUncaughtExceptionHandler(newHandler);
        }
    }

    void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.handler = handler;
    }

    public void setContext(Context ctx) {
        if (ctx == null) {
            Log.e("Context cannot be null");
        } else {
            GAServiceManager sm = GAServiceManager.getInstance();
            this.setContext(ctx, new ParameterLoaderImpl(ctx.getApplicationContext()), GoogleAnalytics.getInstance(ctx.getApplicationContext()), sm);
        }
    }

    void setContext(Context ctx, ParameterLoader parameterLoader, Analytics ga, ServiceManager serviceManager) {
        if (ctx == null) {
            Log.e("Context cannot be null");
        }
        if (this.gaContext == null) {
            this.gaContext = ctx.getApplicationContext();
            this.ga = ga;
            this.serviceManager = serviceManager;
            this.parameterFetcher = parameterLoader;
            this.loadParameters();
        }
    }

    public void activityStart(Activity activity) {
        this.setContext((Context)activity);
        if (!this.gaEnabled) {
            return;
        }
        this.clearExistingTimer();
        if (!this.inForeground && this.activitiesActive == 0 && this.checkForNewSession()) {
            this.tracker.setStartSession(true);
            if (!this.autoActivityTracking) {
                // empty if block
            }
        }
        this.inForeground = true;
        ++this.activitiesActive;
        if (this.autoActivityTracking) {
            this.tracker.trackView(this.getActivityName(activity));
        }
    }

    public void activityStop(Activity activity) {
        this.setContext((Context)activity);
        if (!this.gaEnabled) {
            return;
        }
        --this.activitiesActive;
        this.activitiesActive = Math.max(0, this.activitiesActive);
        this.lastOnStopTime = this.clock.currentTimeMillis();
        if (this.activitiesActive == 0) {
            this.clearExistingTimer();
            this.timerTask = new NotInForegroundTimerTask();
            this.timer = new Timer("waitForActivityStart");
            this.timer.schedule(this.timerTask, 1000L);
        }
    }

    public void dispatch() {
        if (this.gaEnabled) {
            this.serviceManager.dispatch();
        }
    }

    private synchronized void clearExistingTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private String getActivityName(Activity activity) {
        String canonicalName = activity.getClass().getCanonicalName();
        if (this.activityNameMap.containsKey(canonicalName)) {
            return this.activityNameMap.get(canonicalName);
        }
        String name = this.parameterFetcher.getString(canonicalName);
        if (name == null) {
            name = canonicalName;
        }
        this.activityNameMap.put(canonicalName, name);
        return name;
    }

    static void clearTracker() {
        instance = null;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    int getActivitiesActive() {
        return this.activitiesActive;
    }

    private class NotInForegroundTimerTask
    extends TimerTask {
        private NotInForegroundTimerTask() {
        }

        @Override
        public void run() {
            EasyTracker.this.inForeground = false;
        }
    }

    class NoopTracker
    implements Tracker {
        private String appId;
        private String appInstallerId;
        private double sampleRate = 100.0;
        private boolean anonymizeIp;
        private boolean useSecure;
        private ExceptionParser exceptionParser;

        NoopTracker() {
        }

        @Override
        public void setStartSession(boolean startSession) {
        }

        @Override
        public void setAppName(String appName) {
        }

        @Override
        public void setAppVersion(String appVersion) {
        }

        @Override
        public void setAppScreen(String appScreen) {
        }

        @Override
        public void trackView() {
        }

        @Override
        public void trackView(String appScreen) {
        }

        @Override
        public void trackEvent(String category, String action, String label, Long value) {
        }

        @Override
        public void trackTransaction(Transaction transaction) {
        }

        @Override
        public void trackException(String description, boolean fatal) {
        }

        @Override
        public void trackException(String threadName, Throwable exception, boolean fatal) {
        }

        @Override
        public void trackTiming(String category, long intervalInMilliseconds, String name, String label) {
        }

        @Override
        public void trackSocial(String network, String action, String target) {
        }

        @Override
        public void close() {
        }

        @Override
        public void send(String hitType, Map<String, String> params) {
        }

        @Override
        public String get(String key) {
            return "";
        }

        @Override
        public void set(String key, String value) {
        }

        @Override
        public String getTrackingId() {
            return "";
        }

        @Override
        public void setAnonymizeIp(boolean anonymizeIp) {
            this.anonymizeIp = anonymizeIp;
        }

        @Override
        public boolean anonymizeIpEnabled() {
            return this.anonymizeIp;
        }

        @Override
        public void setSampleRate(double sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public double getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public void setUseSecure(boolean useSecure) {
            this.useSecure = useSecure;
        }

        @Override
        public boolean getUseSecure() {
            return this.useSecure;
        }

        @Override
        public void setReferrer(String referrer) {
        }

        @Override
        public void setCampaign(String campaign) {
        }

        @Override
        public void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public String getAppId() {
            return this.appId;
        }

        @Override
        public void setAppInstallerId(String appInstallerId) {
            this.appInstallerId = appInstallerId;
        }

        @Override
        public String getAppInstallerId() {
            return this.appInstallerId;
        }

        @Override
        public void setExceptionParser(ExceptionParser exceptionParser) {
            this.exceptionParser = exceptionParser;
        }

        @Override
        public ExceptionParser getExceptionParser() {
            return this.exceptionParser;
        }

        @Override
        public Map<String, String> constructEvent(String category, String action, String label, Long value) {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> constructTransaction(Transaction trans) {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> constructException(String exceptionDescription, boolean fatal) {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> constructRawException(String threadName, Throwable exception, boolean fatal) {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> constructTiming(String category, long intervalInMilliseconds, String name, String label) {
            return new HashMap<String, String>();
        }

        @Override
        public Map<String, String> constructSocial(String network, String action, String target) {
            return new HashMap<String, String>();
        }

        @Override
        public void setCustomDimension(int slot, String value) {
        }

        @Override
        public void setCustomMetric(int slot, Long value) {
        }

        @Override
        public void setCustomDimensionsAndMetrics(Map<Integer, String> dimensions, Map<Integer, Long> metrics) {
        }
    }
}

