/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.text.TextUtils;

public class Item {
    private final String productSKU;
    private final String productName;
    private final String productCategory;
    private final long itemPriceInMicros;
    private final long itemQuantity;

    private Item(Builder builder) {
        this.productSKU = builder.productSKU;
        this.itemPriceInMicros = builder.itemPriceInMicros;
        this.itemQuantity = builder.itemQuantity;
        this.productName = builder.productName;
        this.productCategory = builder.productCategory;
    }

    public String getProductSKU() {
        return this.productSKU;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductCategory() {
        return this.productCategory;
    }

    public long getItemPriceInMicros() {
        return this.itemPriceInMicros;
    }

    public long getItemQuantity() {
        return this.itemQuantity;
    }

    public static class Builder {
        private final String productSKU;
        private final long itemPriceInMicros;
        private final long itemQuantity;
        private final String productName;
        private String productCategory = null;

        public Builder(String productSKU, String productName, long itemPriceInMicros, long itemQuantity) {
            if (TextUtils.isEmpty((CharSequence)productSKU)) {
                throw new IllegalArgumentException("productSKU must not be empty or null");
            }
            if (TextUtils.isEmpty((CharSequence)productName)) {
                throw new IllegalArgumentException("itemName must not be empty or null");
            }
            this.productSKU = productSKU;
            this.productName = productName;
            this.itemPriceInMicros = itemPriceInMicros;
            this.itemQuantity = itemQuantity;
        }

        public Builder setProductCategory(String productCategory) {
            this.productCategory = productCategory;
            return this;
        }

        public Item build() {
            return new Item(this);
        }
    }
}

