import { Action } from '@ngrx/store';

export enum SearchActionTypes {
   Search = 'Wyszukiwanie [Product]',
   SearchSuccess = 'Wyszukiwanie [Product] powiodło się',
   SearchFailure = 'Wyszukiwanie [Product] nie powiodło się'
}

export class SearchAction implements Action {
  readonly type = SearchActionTypes.Search;

  constructor(public payload: { searchQuery: string }) {}
}

export class SearchSuccessAction implements Action {
  readonly type = SearchActionTypes.SearchSuccess;

  constructor(public payload: { searchResults: string[] }) {}
}

export class SearchFailureAction implements Action {
  readonly type = SearchActionTypes.SearchFailure;

  constructor(public payload: { errorMessage: string }) {}
}

export type SearchActions = SearchAction | SearchSuccessAction | SearchFailureAction;
