import {Subject} from 'rxjs/Subject';

enum Action{
    buy = 'KUP',
    sell = 'SPRZEDAJ'
}

class Order{
    constructor(public orderId: number, public traderId: number, public stock: string, public shares: number, public action:Action){}
}

let orders: Subject<Order> = new Subject<Order>();

class Trader {

    constructor(private traderId:number, private traderName:string){}

    placeOrder(order: Order){
        orders.next(order);
    }
}

let subscriber1 = orders.subscribe(ord => console.log(`Subskrybent 1. otrzymał zamówienie na ${ord.action} ${ord.shares} akcji ${ord.stock}`));
let subscriber2 = orders.subscribe(ord => console.log(`Subskrybent 2. otrzymał zamówienie na ${ord.action} ${ord.shares} akcji ${ord.stock}`));

let trader: Trader = new Trader(1, 'Jaś');
let order1:Order = new Order(1, 1,'IBM',100,Action.buy);
let order2:Order = new Order(2, 1,'AAPL',100,Action.sell);

trader.placeOrder( order1);
subscriber2.unsubscribe();
trader.placeOrder( order2);
