import {Component} from "@angular/core";
import {HttpClient, HttpErrorResponse} from "@angular/common/http";

@Component({
  selector: 'app-root',
  template: `<h1>Dodaj nowy produkt</h1>
     <form #f="ngForm" (ngSubmit) = "addProduct(f.value)" >
       Nazwa: <input id="productTitle" name="title" ngModel>
       <br>
       Cena: <input id="productPrice" name="price" ngModel>
       <br>
       <button type="submit">Dodaj produkt</button>
     </form>
     {{response}}
  `})
export class AppComponent {

  response: string;

  constructor(private httpClient: HttpClient) {}

  addProduct(formValue){

    this.response='';

    this.httpClient.post<string>("/api/product",
                                 formValue)
      .subscribe(
        data =>  this.response = data['message'],
        (err: HttpErrorResponse) =>
            this.response = `Nie można dodać produktu. kod błędu:
              ${err.message} ${err.error.message}`
      );
  }
}
