let {Observable} = require('rxjs/Observable');
require('rxjs/add/operator/catch');
require('rxjs/add/operator/map');

function getData(){

    var beers = [
        {name: "Stella", country: "Belgia", price: 9.50},
        {name: "Sam Adams", country: "Stany Zjednoczone", price: 8.50},
        {name: "Bud Light", country: "Stany Zjednoczone", price: 6.50},
        {name: "Brooklyn Lager", country: "Stany Zjednoczone", price: 8.00},
        {name: "Sapporo", country: "Japonia", price: 7.50}
    ];

    return Observable.create( observer => {
        let counter = 0;
        beers.forEach( beer => {
            observer.next(beer);
            counter++;

            if (counter > Math.random() * 5) {    // Randomly generate an error
                observer.error(
                    {
                        status: 500,
                        description: "Błąd strumienia piw"
                    }
                );
            }
        }
        );

        observer.complete();
      }
    );
}

// Subscribing to data from the primary source
getData()
    .catch(err => {  // failover

        console.error("Otrzymano " + err.status + ": " + err.description);
        if (err.status === 500){
            console.error(">>> Przełączanie na pobieranie zbuforowanych danych");
            return getCachedData();
        } else{
            return Rx.Observable.empty();  // don't handle the error
        }

    })
    .map(beer => beer.name + ", " + beer.country)
    .subscribe(
        beer => console.log("Subkrybent otrzymał " + beer),
        err => console.error(err),
        () => console.log("Koniec strumienia")
    );


function getCachedData(){

    var beers = [
        {name: "Leffe Blonde", country: "Belgia", price: 9.50},
        {name: "Miller Lite", country: "Stany Zjednoczone", price: 8.50},
        {name: "Corona", country: "Meksyk", price: 8.00},
        {name: "Asahi", country: "Japonia", price: 7.50}
    ];

    return Observable.create( observer => {

        beers.forEach( beer => {
                observer.next(beer);
            }
        );

        observer.complete();}
    );
}
