import {Component} from "@angular/core";
import {ObservableService} from "./observable.service";

@Component({
  selector: 'app-root',
  providers: [ ObservableService ],
  template: `<h1>Niestandardowa usługa obserwowalna</h1>
       Aktualny czas: {{currentTime | date: 'mediumTime'}}
  `})
export class AppComponent {

  currentTime: Date;

  constructor(private observableService: ObservableService) {

    this.observableService.createObservableService()
      .subscribe( data => this.currentTime = data );
  }
}
