(test/e2e/signup_flow_test.js)
var SignupPage = require('../pages/signup.js')
  , MainPage = require('../pages/main.js');

describe('signup flow tests', function() {
  var page;

  beforeEach(function() {
    // zainicjowanie obiektu strony
    page = new MainPage();
  });

  it('powinna kierować do folderu /signup jeśli jeszcze nie jest bieżący', function() {
    // sprawdzenie, czy wybrano prawidłowy znacznik <a> poprzez dopasowanie tekstu, który zawiera
    // expect(link.getText()).toEqual('Przejdź do strony rejestracji');
    expect(page.signupLink.getText()).toEqual('Przejdź do strony rejestracji');
    // skierowanie przeglądarki do bezsensownego adresu url
    browser.get('/#/hooplah');
    // symulowane kliknięcie
    page.signupLink.click();
    // protractor oczekuje na wyrenderowanie strony, a następnie sprawdza url
    expect(browser.getCurrentUrl()).toMatch('/signup');
  });
});

describe('testy routowania', function() {
  var page;

  function verifyInvalid() {
    expect(page.successMessageVisibility).toBe(false);
    expect(page.failureMessageVisibility).toBe(true);
  }

  function verifyValid() {
    expect(page.successMessageVisibility).toBe(true);
    expect(page.failureMessageVisibility).toBe(false);
  }

  beforeEach(function() {
    // zainicjowanie obiektu strony
    page = new SignupPage();

    // sprawdzenie, czy są dwa komunikaty na stronie
    expect(page.messages.count()).toEqual(2);
    // sprawdzenie, czy tekst wprowadzania uchwytu jest pusty
    expect(page.handleInput.getText()).toEqual('');
  });

  it('powinna wyświetlać nieprawidłowy uchwyt przy ładowaniu strony', function() {
    // sprawdzenie, czy początkowy stan strony jest niepoprawny
    verifyInvalid();
    expect(page.failureMessage.getText()).
      toEqual('Niestety, ten uchwyt nie może być użyty.');
  });

  it('powinna wyświetlać nieprawidłowy uchwyt w przypadku niewystarczającej liczby znaków',function() {
    // wpisanie wartości w celu zmodyfikowania modelu i zainicjowania wyrażenia $watch
    page.typeHandle('jacek');
    verifyInvalid();
  })

  it('powinna wyświetlać nieprawidłowy uchwyt w przypadku zajętego uchwytu', function() {
    // wpisanie wartości w celu zmodyfikowania modelu i zainicjowania wyrażenia $watch
    page.typeHandle('jacekhorbaczewski');
    verifyInvalid();
  })

  it('powinna wyświetlać prawidłowy uchwyt dla uchwytu niezajętego', function() {
    // wpisanie wartości w celu zmodyfikowania modelu i zainicjowania wyrażenia $watch
    page.typeHandle('jacekhorbaczewski123');
    verifyValid();
  })
})

