// httpMockBackend.js

// Zdefiniowanie pewnych zmiennych początkowych.
var applicationRoot = __dirname.replace(/\\/g,"/"),
  ipaddress = process.env.OPENSHIFT_NODEJS_IP || '127.0.0.1',
  port = process.env.OPENSHIFT_NODEJS_PORT || 5001;
  mockRoot = applicationRoot + '/test/mocks/api',
  mockFilePattern = '.json',
  mockRootPattern = mockRoot + '/**/*' + mockFilePattern,
  apiRoot = '/api',
  fs = require("fs"),
  glob = require("glob");
// Utworzenie aplikacji Express
var express = require("express");
var app = express();
// Odczytanie drzewa katalogu zgodnie ze wzorcem określonym powyżej.
var files = glob.sync(mockRootPattern);
// Rejestracja odwzorowania dla każdego pliku znalezionego w drzewie katalogów.
if(files && files.length > 0) {
  files.forEach(function(filePath) {
    var mapping = apiRoot + filePath.replace(mockRoot, '').replace(mockFilePattern,'')
      , fileName = filePath.replace(/^.*[\\\/]/, '');
    //ustawienie nagłówków CORS tak, by można było z nich skorzystać w lokalnych wywołaniach AJAX
    app.all('*', function(req, res, next) {
      res.header("Access-Control-Allow-Origin", "*");
      res.header("Access-Control-Allow-Headers", "X-Requested-With");
      next();
    });
    // czasowniki HTTP, które mogą być potrzebne
    [/^GET/, /^POST/, /^PUT/, /^PATCH/, /^DELETE/].forEach(
      function(httpVerbRegex) {
        // sprawdzenie początkowego wyrażenia regularnego czasownika HTTP
        var match = fileName.match(httpVerbRegex);
        if (match != null) {
          // usunięcie prefiksu czasownika HTTP z nazwy pliku
          mapping = mapping.replace(match[0]+"_", "");
          // utworzenie punktu końcowego
          app[match[0].toLowerCase()](mapping, function (req, res) {
            // obaługa żądania poprzez udzielenie odpowiedzi zawierającej zawartość JSON pliku
            var data = fs.readFileSync(filePath, 'utf8');
            res.writeHead(200, { 'Content-Type': 'application/json' });
            res.write(data);
            res.end();
          });
        }
      }
    );
    console.log('Zarejestrowano mapowanie: %s -> %s', mapping, filePath);
  })
} else {
    console.log('Nie znaleziono mapowania! Proszę sprawdzić konfigurację.');
}
// Uruchomienie serwera-makiety API.
console.log('Katalog główny aplikacji: [' + applicationRoot +']');
console.log('Serwer-makieta Api nasłuchuje pod adresem: [http://' + ipaddress + ':' + port + ']');
app.listen(port, ipaddress);
