(handle_controller_test.js)
// monolityczny zestaw testów dla HandleCtrl

describe('Controller: HandleCtrl', function() {
  // komponenty, które mają być testowane rezydują w module myApp
  // dlatego trzeba go wstrzyknąć
  beforeEach(module('myApp'));

  // wartości, które będą używane w wielu domknięciach
  var HandleCtrl, scope, httpBackend, createEndpointExpectation;

  // ten fragment będzie uruchamiany przed każdą klauzulą it(function() {})
  // w celu stworzenia bądź odświeżenia wykorzystywanych komponentów
  beforeEach(inject(function($controller, $rootScope, $httpBackend) {

    // tworzy makietę serwera backend
    httpBackend = $httpBackend;

    // tworzy świeży zakres
    scope = $rootScope.$new();

    // tworzy nowy egzemplarz kontrolera i wstawia do niego
    // utworzony zakres
    HandleCtrl = $controller('HandleCtrl', {
      $scope: scope
    });

    // konfiguruje httpBackend w celu dopasowania wychodzących żądań
    // które zgodnie z oczekiwaniami mają być wygenerowane przez kontroler
    // i zwraca dane na podstawie tego, co zawierało żądanie;
    // funkcja będzie wywoływana tylko wtedy, gdy będzie potrzebna
    createEndpointExpectation = function() {
      // Mechanizm dopasowywania URL wykorzystuje tutaj proste wyrażenie regularne
      // expectGET wymaga stworzenia żądania
      httpBackend.expectGET(/\/api\/handle\/\w+/i).respond(
        function(method, url, data, headers){
          var urlComponents = url.split("/")
            , handle = urlComponents[urlComponents.length - 1]
            , payload = {handle: handle};
          if (handle == 'jacekhorbaczewski') {
            // uchwyt istnieje w bazie danych, zwracamy ID
            payload.id = 1;
          } else {
            // uchwyt nie istnieje w bazie danych
            payload.id = null;

          };

          // Framework AngularJS pozwala na ten format zwracanej wartości;
          // [status code, data, configuration]
          return [200, payload, {}];
        }
      );
    };
  }));

  // konfiguruje httpBackend w celu sprawdzenia, czy serwer-makieta
  // nie otrzymał dodatkowych żądań lub nie zaobserwował
  // żądania, kiedy powinien się jakiegoś spodziewać
  afterEach(function() {

    // weryfikacja, czy wypełniono wzystkie oczekiwania expect<HTTPverb>()
    httpBackend.verifyNoOutstandingExpectation();

    // sprawdzenie, czy serwer-makieta nie otrzymał żądań,
    // których nie oczekiwał
    httpBackend.verifyNoOutstandingRequest();
  });

  // test jednostkowy dla nieprawidłowego klienta
  it('Powinien oznaczyć zbyt krótkie uchwyty jako nieprawidłowe', 
    function() {
      // próba przesłania testowego uchwytu poniżej progowej liczby znaków
      scope.handle = 'jacek';

      // klauzula $watch nie uruchomi się jeśli nie wymusimy pętli przeglądu
      scope.$apply();

      // Aby test przechodził, musi być spełniona ta klauzula
      expect(scope.valid).toBe(false);
    }
  );

  // test jednostkowy: na kliencie dane poprawne, na serwerze nieprawidłowe
  it('Powinien oznaczyć uchwyty istniejące na serwerze jako nieprawidłowe', 
    function() {
      // serwer skonfigurowano tak, aby oczekiwał określonego żądania
      createEndpointExpectation();

      // próba przesłania testowego uchwytu powyżej progowej liczby znaków,
      // zdefiniowanego na serwerze-makiecie jako 
      // zajętego
      scope.handle = 'jacekhorbaczewski';

      // wymuszenie pętli przeglądu
      scope.$apply();

      // serwer-makieta nie zwróci odpowiedzi do czasu 
      // wywołania flush()
      httpBackend.flush();

      // Aby test przechodził, musi być spełniona ta klauzula
      expect(scope.valid).toBe(false);
    }
  );

  // test jednostkowy: na kliencie dane poprawne, na serwerze nieprawidłowe
  it('Powinien oznaczać uchwyty dostępne na serwerze jako prawidłowe', 
    function() {

      // serwer skonfigurowano tak, aby oczekiwał określonego żądania
      createEndpointExpectation();

      // próba użycia uchwytu powyżej progu liczby znaków oraz takiego,
      // który został zdefiniowany jako dostępny na serwerze-makiecie
      scope.handle = 'jacekhorbaczewski123';

      // wymuszenie pętli przeglądu
      scope.$apply();

      // zwrócenie odpowiedzi
      httpBackend.flush();

      // Aby test przechodził, musi być spełniona ta klauzula
      expect(scope.valid).toBe(true);
    }
  )
});

