(test/e2e/signup_flow_test.js)
describe('signup flow tests', function() { 
  it('powinna kierować do folderu /signup jeśli jeszcze nie jest bieżący', function() {
    // kieruje przeglądarkę do względnego adresu url, strona zostanie załadowana synchronicznie
    browser.get('/');

    // zlokalizowanie na stronie znacznika <a> i pobranie go stamtąd
    var link = element(by.css('a'));

    // sprawdzenie, czy wybrano prawidłowy znacznik <a> poprzez dopasowanie tekstu, który zawiera
    expect(link.getText()).toEqual('Przejdź do strony logowania');

    // skierowanie przeglądarki do bezsensownego adresu url
    browser.get('/#/hooplah');

    // symulowane kliknięcie
    link.click();

    // protractor oczekuje na wyrenderowanie strony, a następnie sprawdza url
    expect(browser.getCurrentUrl()).toMatch('/signup');
  });
});
describe('testy routowania', function() {
  var handleInput,
      successMessage,
      failureMessage;

  function verifyInvalid() {
    expect(successMessage.isDisplayed()).toBe(false);
    expect(failureMessage.isDisplayed()).toBe(true);
  }

  function verifyValid() {
    expect(successMessage.isDisplayed()).toBe(true);
    expect(failureMessage.isDisplayed()).toBe(false);
  }

  beforeEach(function() {
    browser.get('/#/signup');

    var messages = element.all(by.css('h2'));

    expect(messages.count()).toEqual(2);

    successMessage = messages.get(0);
    failureMessage = messages.get(1);

    handleInput = element(by.model('handle'));
    
    expect(handleInput.getText()).toEqual('');
  })

  it('powinna wyświetlać nieprawidłowy uchwyt przy ładowaniu strony', function() {
    verifyInvalid();
    expect(failureMessage.getText()).
      toEqual('Niestety, ten uchwyt nie może być użyty.');
  });

  it('powinna odrzucać nieprawidłowe uchwyty', function() {
    // wpisanie wartości w celu zmodyfikowania modelu i zainicjowania wyrażenia $watch
    ['jacek', 'jacekhorbaczewski'].forEach(function(handle){
      handleInput.clear();
      handleInput.sendKeys(handle);
      verifyInvalid();
    });
  });

  it('powinna wyświetlać prawidłowy uchwyt dla uchwytu niezajętego', function() {
    // wpisanie wartości w celu zmodyfikowania modelu i zainicjowania wyrażenia $watch
    handleInput.sendKeys('jacekhornaczewski123');
    verifyValid();
  });
})

