// Plik: r14/simpleRoutingSpec.js

describe('Routing Test', function() {

  it('Powinien wyświetlić drużyny na pierwszej stronie.', function() {
    // otwiera stronę z listą drużyn
    browser.get('/');

    // sprawdzenie czy w pętli jest pięć wierszy
    var rows = element.all(
        by.repeater('Drużyna w teamListCtrl.teams'));
    expect(rows.count()).toEqual(5);

    // sprawdza szczegóły pierwszego wiersza
    var firstRowRank = element(
      by.repeater('Drużyna w teamListCtrl.teams')
        .row(0).column('team.rank'));
    var firstRowName = element(
      by.repeater('Drużyna w teamListCtrl.teams')
        .row(0).column('team.name'));
    expect(firstRowRank.getText()).toEqual('1');
    expect(firstRowName.getText()).toEqual('Hiszpania');

    // sprawdzenie szczegółów ostatniego wiersza
    var lastRowRank = element(
      by.repeater('Drużyna w teamListCtrl.teams')
        .row(4).column('team.rank'));
    var lastRowName = element(
      by.repeater('Drużyna w teamListCtrl.teams')
        .row(4).column('team.name'));
    expect(lastRowRank.getText()).toEqual('5');
    expect(lastRowName.getText()).toEqual('Urugwaj');

    // sprawdzenie czy odnośnik logowania jest wyświetlony,
    // a odnośnik wylogowywania jest ukryty
    expect(element(by.css('.login-link')).isDisplayed())
        .toBe(true);
    expect(element(by.css('.logout-link')).isDisplayed())
        .toBe(false);
  });

  it('Powinien umożliwiać logowanie.', function() {
    // przejście na stronę logowania
    browser.get('#/login');

    var username = element(
      by.model('loginCtrl.user.username'));
    var password = element(
      by.model('loginCtrl.user.password'));

    // wpisuje nazwę użytkownika i hasło
    username.sendKeys('admin');
    password.sendKeys('admin');

    // klika przycisk logowania
    element(by.css('.btn.btn-success')).click();

    // sprawdza czy użytkownik na pewno został przekierowany
    expect(browser.getCurrentUrl())
        .toEqual('http://localhost:8000/#/');

    // sprawdzenie czy odnośnik logowania jest ukryty,
    // a odnośnik wylogowywania jest wyświetlony
    expect(element(by.css('.login-link')).isDisplayed())
        .toBe(false);
    expect(element(by.css('.logout-link')).isDisplayed())
        .toBe(true);

  });
});
