describe("Treningomat", function () {

    var WorkoutRunnerPage = function () {
        this.description = element(by.binding("currentExercise.details.description"));
        this.steps = element(by.binding("currentExercise.details.procedure"));
        this.videos = element.all(by.repeater("video in currentExercise.details.related.videos"));
        this.pauseResume = element(by.id("pause-overlay"));
        this.exerciseHeading = element(by.binding("currentExercise.details.title"));
        this.workoutTimeRemaining = element(by.binding("workoutTimeRemaining"))
        this.exerciseTimeRemaining = element(by.binding("currentExercise.duration-currentExerciseDuration"));
    }; 

    describe("Strona główna", function () {
        beforeEach(function () {
            browser.get("");
        });
        it("powinna zostać wczytana strona główna.", function () {
            expect(browser.getTitle()).toBe("Mój trening");
            expect(element(by.id("start")).getText()).toBe("Wybierz trening");
        });

        it("powinna wyszukać trening o podanej nazwie.", function () {
            var filteredWorkouts = element.all(by.repeater("workout in workouts"));
            expect(filteredWorkouts.count()).toEqual(2);

            var searchInput = element(by.model("workoutSearch"));
            searchInput.sendKeys("test");

            expect(filteredWorkouts.count()).toEqual(1);
            expect(filteredWorkouts.first().element(by.css(".title")).getText()).toBe("Trening testowy");
        });

        it("powinna przejść do strony tremingu.", function () {
            var filteredWorkouts = element.all(by.repeater("workout in workouts"));
            filteredWorkouts.first().click();
            expect(browser.getCurrentUrl()).toContain("/workout/7minworkout");
        });

    });

    describe("strona treningu", function () {
        beforeEach(function () {
            browser.get("#/workout/testworkout");
        });

        it("powinna wstrzymać trening po kliknięciu przycisku pauzy", function () {
            var page = new WorkoutRunnerPage(),
                timeRemaining;

            page.pauseResume.click();
            expect(page.pauseResume.all(by.css(".glyphicon-play")).count()).toBe(1);
            expect(page.pauseResume.all(by.css(".glyphicon-pause")).count()).toBe(0);

            page.exerciseTimeRemaining.getText().then(function (time) {
                timeRemaining = time;
                browser.sleep(3000);
            });
            page.exerciseTimeRemaining.getText().then(function (time) {
                expect(page.exerciseTimeRemaining.getText()).toBe(timeRemaining);
            });

        });

        it("powinna wczytać dane treningu", function () {
            var page = new WorkoutRunnerPage();
            page.pauseResume.click();
            expect(page.description.getText()).toBe("Proste napinanie mięśni brzucha jest podstawowym ćwiczeniem programu wzmacniającego.");
            expect(page.exerciseHeading.getText()).toBe("Napinanie brzucha");
            expect(page.videos.count()).toBe(2);
        });

        it("powinna przejść do następnego ćwiczenia po upłynięciu określonego czasu.", function () {
            var page = new WorkoutRunnerPage();
            browser.sleep(5000);
            page.pauseResume.click();
            expect(page.videos.count()).toBe(0);
            expect(page.description.getText()).toBe("Odpocznij trochę!");
            expect(page.exerciseHeading.getText()).toBe("Odpoczynek!");
        });

        it("powinna zakończyć trening po upłynięciu czasu", function () {
            var page = new WorkoutRunnerPage();
            browser.sleep(20000);
            expect(browser.getCurrentUrl()).toContain("/finish");
        });
    });
});