'use strict';

angular.module('WorkoutBuilder')
  .controller('WorkoutListController', ['$scope', 'WorkoutService', '$location', function ($scope, WorkoutService, $location) {
      $scope.goto = function (workout) {
          $location.path('/builder/workouts/' + workout.name);
      }
      var init = function () {
          $scope.workouts = WorkoutService.getWorkouts();
      };
      init();
  }]);

angular.module('WorkoutBuilder')
  .controller('WorkoutDetailController', ['$scope', 'WorkoutBuilderService', 'selectedWorkout', function($scope, WorkoutBuilderService, selectedWorkout) {
      $scope.removeExercise = function (exercise) {
          WorkoutBuilderService.removeExercise(exercise);
      };

      $scope.durations = [{ title: "15 sekund", value: 15 },
                          { title: "30 sekund", value: 30 },
                          { title: "45 sekund", value: 45 },
                          { title: "1 minuta", value: 60 },
                          { title: "1 minuta i 15 sekund", value: 75 },
                          { title: "1 minuta i 30 sekund", value: 90 },
                          { title: "1 minuta i 45 sekund", value: 105 },
                          { title: "2 minuty", value: 120 },
                          { title: "2 minuty i 15 sekund", value: 135 },
                          { title: "2 minuty i 30 sekund", value: 150 },
                          { title: "2 minuty i 45 sekund", value: 165 },
                          { title: "3 minuty", value: 180 },
                          { title: "3 minuty i 15 sekund", value: 195 },
                          { title: "3 minuty i 30 sekund", value: 210 },
                          { title: "3 minuty i 45 sekund", value: 225 },
                          { title: "4 minuty", value: 240 },
                          { title: "4 minuty i 15 sekund", value: 255 },
                          { title: "4 minuty i 30 sekund", value: 270 },
                          { title: "4 minuty i 45 sekund", value: 285 },
                          { title: "5 minut", value: 300 }];

      $scope.moveExerciseTo = function (exercise, location) {
          WorkoutBuilderService.moveExerciseTo(exercise, location);
      };

      var init = function () {
          $scope.workout = selectedWorkout; // wyznaczony obiekt treningu
      };
      init();
  }]);  