'use strict';

/* Dyrektywy */
angular.module('app').directive('ngConfirm', [function () {
    return {
        restrict: 'A',
        link: function (scope, element, attrs) {
            element.bind('click', function () {
                var message = attrs.ngConfirmMessage || 'Czy jesteś pewny?';
                if (message && confirm(message)) {
                    scope.$apply(attrs.ngConfirm);
                }
            });
        }
    }
}]);

// Walidator dla wersji starszych od Angular 1.3. Należy go używać w razie korzystania ze starszych wersji Angular
//angular.module('app').directive('remoteValidator', ['$parse', function ($parse) {
//    return {
//        restrict: 'A',
//        priority: 5,
//        require: ['ngModel', '?^busyIndicator'],
//        link: function (scope, elm, attr, ctrls) {
//            var expfn = $parse(attr["remoteValidatorFunction"]);
//            var validatorName = attr["remoteValidator"];
//            var ngModelCtrl = ctrls[0];
//            var busyIndicator = ctrls[1];
//            ngModelCtrl.$parsers.push(function (value) {
//                var result = expfn(scope, { 'value': value });
//                if (result.then) {
//                    if (busyIndicator) busyIndicator.show();
//                    result.then(function (data) { // gdy zwracanym obiektem jest obietnica
//                        if (busyIndicator) busyIndicator.hide();
//                        ngModelCtrl.$setValidity(validatorName, data);
//                    }, function (error) {
//                        if (busyIndicator) busyIndicator.hide();
//                        ngModelCtrl.$setValidity(validatorName, true);
//                    });
//                }
//                return value;
//            });
//        }
//    }
//}]);

// Walidator dla wersji Angular zaczynając od 1.3. Stosuj go jeśli używasz Angular 1.3 lub nowszej wersji.
angular.module('app').directive('remoteValidator', ['$parse', function ($parse) {
    return {
        restrict: 'A',
        require: ['ngModel', '?^busyIndicator'],
        link: function (scope, elm, attr, ctrls) {
            var expfn = $parse(attr["remoteValidatorFunction"]);
            var validatorName = attr["remoteValidator"];
            var ngModelCtrl = ctrls[0];
            var busyIndicator = ctrls[1];

            ngModelCtrl.$asyncValidators[validatorName] = function (value) {
                return expfn(scope, { 'value': value });
            }
            if (busyIndicator) {
                scope.$watch(function () { return ngModelCtrl.$pending; }, function (newValue) {
                    if (newValue) busyIndicator.show();
                    else busyIndicator.hide();
                });
            }
        }
    }
}]);

// Angular 1.3 dysponuje wybudowaną dyrektywą do obsługi aktualizacji przy wychodzeniu z pola (blur).
// Zamiast używać dyrektywy update-on-blur, w Angular 1.3 można skorzystać z ng-model-options="{ updateOn: 'blur' }" for Angular 1.3
angular.module('app').directive('updateOnBlur', function () {
    return {
        restrict: 'A',
        require: 'ngModel',
        priority: '100',
        link: function (scope, elm, attr, ngModelCtrl) {
            if (attr.type === 'radio' || attr.type === 'checkbox') return;
            elm.unbind('input').unbind('keydown').unbind('change');
            elm.bind('blur', function () {
                scope.$apply(function () {
                    ngModelCtrl.$setViewValue(elm.val());
                });
            });
        }
    };
});

angular.module('app').directive('busyIndicator', ['$compile', function ($compile) {
    return {
        scope: true,
        transclude: true,
        template: '<div><div ng-transclude=""></div><label ng-show="busy" class="text-info glyphicon glyphicon-refresh spin"></label></div>',
        //compile: function (element, attr) {
        //    // Ta wersja dyrektywy wstrzykuje dynamiczny kod HTML podczas fazy kompilacji.
        //    // Aby jej używać, należy poprzedzić komentarzami właściwości transclude:... oraz template:...
        //    // Kompilacja kodu HTML przed wstrzyknięciem go do DOM nie jest konieczna.
        //    // Wystarczy dodać kod HTML za elementem DOM, a AngularJS skompiluje i skonsoliduje dodawany fragment.
        //    var busyHtml = '<div><label ng-show="busy" class="text-info glyphicon glyphicon-refresh spin"></label></div>';
        //    element.append(busyHtml);
        //    return function (scope, element, attr) { }  //funkcja konsolidująca
        //},
        //link: function (scope, element, attr) {
        //    // Ta wersja dyrektywy wstrzykuje dynamiczny kod HTML podczas fazy konsolidacji.
        //    // Aby jej używać, należy poprzedzić komentarzami właściwości transclude:... oraz template:...
        //    // Do dyrektywy należy także dodać zależność od usługi $compile.
        //    // Kompilacja dodawanego fragmentu HTML przed jego wstawieniem do DOM jest konieczna.
        //    // Wystarczy dodać kod HTML za elementem DOM, a AngularJS go skompiluje.
        //    var linkfn = $compile('<div><label ng-show="busy" class="text-info glyphicon glyphicon-refresh spin"></label></div>');
        //    element.append(linkfn(scope));
        //},
        controller: ['$scope', function ($scope) {
            this.show = function () { $scope.busy = true; }
            this.hide = function () { $scope.busy = false; }
        }]

    }
}]);

angular.module('app').directive('ajaxButton', ['$compile', '$animate', function ($compile, $animate) {
    return {
        transclude: true,
        restrict: 'E',
        scope: {
            onClick: '&',
            submitting: '@'
        },
        replace: true,
        template: '<button ng-disabled="busy"><span class="glyphicon glyphicon-refresh spin" ng-show="busy"></span><span ng-transclude=""></span></button>',
        link: function (scope, element, attr) {
            if (attr.submitting !== undefined && attr.submitting != null) {
                attr.$observe("submitting", function (value) {
                    if (value) scope.busy = JSON.parse(value);
                });
            }
            if (attr.onClick) {
                element.on('click', function (event) {
                    scope.$apply(function () {
                        var result = scope.onClick();
                        if (attr.submitting !== undefined && attr.submitting != null) return;    // Atrybut submitting, jeśli został zdefiniowany, to ma wyższy priorytet; dlatego kończymy.
                        if (result.finally) {
                            scope.busy = true;
                            result.finally(function () { scope.busy = false });
                        }
                    });
                });
            }
        }
    }
}]);