'use strict';

/* Usługi */
angular.module('app')
    .value("appEvents", {
        workout: { exerciseStarted: "event:workout:exerciseStarted" }
    });

angular.module('app')
    .factory("WorkoutService", ['WorkoutPlan', 'Exercise', function (WorkoutPlan, Exercise) {
        var service = {};
        var workouts = [];
        var exercises = [];
        service.getExercises = function () {
            return exercises;
        };

        service.getExercise = function (name) {
            var result = null;
            angular.forEach(service.getExercises(), function (exercise) {
                if (exercise.name === name) result = angular.copy(exercise);
            });
            return result;
        };

        service.updateExercise = function (exercise) {
            angular.forEach(exercises, function (e, index) {
                if (e.name === exercise.name) {
                    exercises[index] = exercise;
                }
            });
            return exercise;
        };

        service.addExercise = function (exercise) {
            if (exercise.name) {
                exercises.push(exercise);
                return exercise;
            }
        }

        service.deleteExercise = function (exerciseName) {
            var exerciseIndex;
            angular.forEach(exercises, function (e, index) {
                if (e.name === exerciseName) {
                    exerciseIndex = index;
                }
            });
            if (exerciseIndex >= 0) exercises.splice(exerciseIndex, 1);
        };


        service.getWorkouts = function () {
            return workouts;
        };

        var setupInitialExercises = function () {
            exercises.push(
                new Exercise({
                    name: "jumpingJacks",
                    title: "Pajacyki",
                    description: "Pajacyki, to proste ćwiczenie fizyczne polegające na podskakiwaniu i wymachiwaniu rękoma.",
                    image: "img/JumpingJacks.png",
                    nameSound: "content/jumpingjacks.wav",
                    videos: ["dmYwZH_BNd0", "BABOdJ-2Z6o", "c4DAnQ6DtF8"],
                    procedure: "Przyjmij pozycję wyprostowaną, stopy mają być razem, a ramiona zwisać swobodnie wzdłuż tułowia.\
                              <br/>Zegnij lekko kolana, a następnie wyskocz kilkanaście centymetrów w powietrze.\
                              <br/>W wyskoku rozchyl nogi na zewnątrz, mniej więcej na szerokość ramienia lub nieco szerzej.\
                              <br/>W trakcie rozszerzania nóg, wykonaj rękoma wymach nad głowę; w trakcie całego ruchu ramiona powinny być lekko zgięte.\
                              <br/>Po wylądowaniu na ziemi stopy powinny być oddalone na odległość ramienia, lekko zgięte ręce mają być uniesione nad głowę i stykać się dłońmi."
                }));

            exercises.push(
                new Exercise({
                    name: "wallSit",
                    title: "Krzesełko",
                    description: "Krzesełko to popularne ćwiczenie wzmacniające mięsień czworogłowy uda.",
                    image: "img/wallsit.png",
                    nameSound: "content/wallsit.wav",
                    videos: ["y-wV4Venusw", "MMV3v4ap4ro"],
                    procedure: "Stań przy ścianie, tak by plecy się o nią opierały a stopy były oddalone od siebie na długość ramienia i nieco oddalone od ściany.\
                                <br/>Następnie, ciągle opierając się o ścianę, zsuń tułów w dół aż do momentu gdy nogi w kolanach utworzą kąt prosty. \
                                <br/>Zachowaj tę pozycję."
               }));

            exercises.push(
                new Exercise({
                    name: "pushUp",
                    title: "Pompki",
                    description: "Pompki to popularne ćwiczenie wykonywane w pozycji leżącej na brzuchu, polegające na podnoszeniu i opuszczaniu ciała na raminach.",
                    image: "img/Pushup.png",
                    nameSound: "content/pushups.wav",
                    videos: ["Eh00_rniF8E", "ZWdBqFLNljc", "UwRLWMcOdwI", "ynPwl6qyUNM", "OicNTT2xzMI"],
                    procedure: "Połóż się płasko na ziemi, podpierając się na zgiętych rękach; dłonie mają być oddalone od siebie na długość ramienia lub nieco więcej. \
                                Zachowując wyprostowane ułożenie ciała podnieś się na rękach, aż do ich całkowitego wyprostowania. \
                                Wciąż zachowując wyprostowane ułożenie ciała, obniż się ku ziemi zginając ręce w łokciach. \
                                Powtarzaj te czynności."
               }));

            exercises.push(
                new Exercise({
                    name: "crunches",
                    title: "Napinanie brzucha",
                    description: "Proste napinanie mięśni brzucha jest podstawowym ćwiczeniem programu wzmacniającego.",
                    image: "img/crunches.png",
                    nameSound: "content/crunches.wav",
                    videos: ["Xyd_fa5zoEU", "MKmrqcoCZ-M"],
                    procedure: "Połóż się płasko na ziemi, ze zgiętymi kolanami i stopami oddalonymi od siebie na szerokość bioder. \
                                Umieść ręce za głową, tak by kciuki znalazły się za uszami. \
                                Łokcie rozsuń na boki i lekko unieś. \
                                Delikatnie napnij mięśnie brzucha. \
                                Zegnij się w przód podnosząc tym samym z podłogi głowę, szyję oraz ramiona. \
                                Utrzymaj przez chwilę taką podniesioną pozycję, a następnie z powrotem opuść górną część ciała na podłogę."
                 }));

            exercises.push(
                new Exercise({
                    name: "stepUpOntoChair",
                    title: "Wchodzenie na krzesło",
                    description: "Wchodzenie na krzesło jest doskonałym ćwiczeniem do budowania mięśni dolnych partii ciała.",
                    image: "img/stepUpOntoChair.png",
                    nameSound: "content/stepup.wav",
                    videos: ["aajhW7DD1EA"],
                    procedure: "Ustaw krzesło przed sobą.\
                                Stań w lekkim rozkroku, stopy mają być oddalone od siebie na długość ramienia, a ręce mają zwisać swobodnie wzdłuż ciała. \
                                Umieść jedną stopę na krześle, a następnie wejdź na krzesło dostawiając drugą stopę do pierwszej. \
                                Zejdź z krzesła zaczynając do pierwszej stopy, następnie zdejmij z niego drugą stopę i stań w pozycji wyjściowej."
               }));

            exercises.push(
                new Exercise({
                    name: "squat",
                    title: "Przysiady",
                    description: "Przysiady są złożonym ćwiczeniem obejmującym wiele parti ciała, trenującym głównie mięśnie ud, bioder i pośladków",
                    image: "img/squat.png",
                    nameSound: "content/squats.wav",
                    videos: ["QKKZ9AGYTi4", "UXJrBgI2RxA"],
                    procedure: "Stań wyprostowany, z wypiętą do przodu klatką piersiową. \
                                Stopy mają się znajdować w odległości ramienia od siebie. Wyciągnij ręce w poziomie przed siebie. \
                                Zagnij kolana obniżając ciało tak jakbyś chciał usiąść na krześle. Trzymaj głowę wyprostowaną i patrz przed siebie, pochylając jednocześnie górną część ciała do przodu. Nie wyginaj tułowia w łuk, a jedynie nieznalcznie zegnij go w dolnej części ku przodowi. \
                                Obniż ciało aż do momentu gdy uda ustawią się równolegle do podłogi, a kolana znajdą się nad kostkami. Przenieś ciężar ciała na pięty. \
                                Trzymaj ciało napięte, a następnie podnieś się do pozycji wyjściowej."
               }));
            exercises.push(
                new Exercise({
                    name: "tricepdips",
                    title: "Pompki w podporze tyłem",
                    description: "Ćwiczenie na masę mięśniową trenujące głównie triceps.",
                    image: "img/tricepdips.png",
                    nameSound: "content/tricepdips.wav",
                    videos: ["tKjcgfu44sI", "jox1rb5krQI"],
                    procedure: "Usiądź na krześle. Nogi powinny być nieco wyprostowane, a stopy umieszczone płasko na ziemi. \
                                Oprzyj śródręcze dłoni tuż przy krawędzi krzesła, tak by palce opadały pionowo w dół. \
                                Bez poruszania nogami przesuń pośladki do przodu, poza krzesło. \
                                Powoli opuść ciało. Kiedy ręce w łokciach będą zgięte pod kątem 90 stopni zatrzymaj się, po czym powoli podnieś ciało w górę do pozycji wyjściowej."
                }));

            exercises.push(
                new Exercise({
                    name: "plank",
                    title: "Leżenie w podporze",
                    description: "Leżenie w podporze jest jednym z podstawowych siłowych ćwiczeń izometrycznych, polegających na utrzymywaniu trudnej pozycji przez dłuższy okres czasu.",
                    image: "img/Plank.png",
                    nameSound: "content/plank.wav",
                    videos: ["pSHjTRCQxIw", "TvxNkmjdhMM"],
                    procedure: "Połóż się płasko na podłodze przyjmując pozycję taką jak podczas robienia pompek.\
                                Zegnij łokcie pod kątem 90 stopni i oprzyj ciężar ciała na przedramionach.\
                                Twoje łokcie powinny się znajdować bezpośrednio pod ramionami, a ciało powinno tworzyć linię prostą zaczynając od głowy, a kończąc na stopach.\
                                Utrzymuj tę pozycję."
                }));

            exercises.push(
                new Exercise({
                    name: "highKnees",
                    title: "Podnoszenie kolan",
                    description: "Popularnie określane także jako Skip-A. Ćwiczenie rozwijające siłę i wytrzymałość zginaczy, mięśnia czworogłowego uda oraz siły mięśni prostowników uda.",
                    image: "img/highknees.png",
                    nameSound: "content/highknees.wav",
                    videos: ["OAJ_J3EZkdY", "8opcQdC-V-U"],
                    procedure: "Stań prosto ze stopami rozszerzonymi na odległość ramienia. \
                                Podnieś kolan w górę, dociągając je maksymalnie do klatki piersiowej."
               }));

            exercises.push(
                new Exercise({
                    name: "lunges",
                    title: "Wypady",
                    description: "Wypady są dobrym ćwiczeniem do wzmacniania, rzeźbienia i budowania kilku grup mięśni, w tym mięśnia czworogłowego, mięśni pośladkowych, jak również ścięgien podkolanowych.",
                    image: "img/lunges.png",
                    nameSound: "content/lunge.wav",
                    videos: ["Z2n58m2i4jg"],
                    procedure: "Stań prosto ze stopami rozszerzonymi na odległość ramienia. \
                                Umieść ręce na biodrach, trzymaj plecy wyprostowane, rozluźnij ramiona i patrz się prosto przed siebie. \
                                Jedną nogą zrób duży wykrok wprzód. \
                                W trakcie robienia wykroku obniż biodra i zegnij nogi w kolanach, tak by uda tworzyły kąt prosty.\
                                Wróć do pozycji wyjściowej. \
                                Powtórz ćwiczenie zaczynając do drugiej nogi."
               }));

            exercises.push(
                new Exercise({
                    name: "pushupNRotate",
                    title: "Pompki z obrotem",
                    description: "Wersja pompek wymagająca wykonania dodatkowego obrotu.",
                    image: "img/pushupNRotate.png",
                    nameSound: "content/pushupandrotate.wav",
                    videos: ["qHQ_E-f5278"],
                    procedure: "Przyjmij klasyczną pozycję do robienia pompek, jednak podczas podnoszenia się, obróć ciało tak, by prawe ramie znalazło się u góry i było wyprostowane nad głową.\
                                Obniż ciało wracając do pozycji wyjściowej, następnie powtórz ćwiczenie wyciągając ku górze lewą rękę. \
                                Powtarzaj tę sekwencję ćwiczeń."
                }));

            exercises.push(
                new Exercise({
                    name: "sidePlank",
                    title: "Unoszenie bioder bokiem",
                    description: "Wariant leżenia w podporze, wykonywany w pozycji bocznej.",
                    image: "img/sideplank.png",
                    nameSound: "content/sideplank.wav",
                    videos: ["wqzrb67Dwf8", "_rdfjFSFKMY"],
                    procedure: "Połóż się na boku układając ciało w linii prostej od głowy do stóp i opierając ciężar ciała na przedramieniu. \
                                Twój łokieć powinien się znajdować bezpośrednio poniżej barkiem. \
                                Ściśnij lekko pośladki i delikatnie unieś biodra z podłogi, zachowując prosty układ ciała. \
                                Trzymaj biodra prosto, a szyję w jednej linii z kręgosłupem. Utrzymaj taką pozycję."
                }));

        };

        var setupInitialWorkouts = function () {
            var exercises = service.getExercises();
            // Istnieje tylko jeden domyślny trening.
            var workout = new WorkoutPlan({
                name: "7minWorkout",
                title: "7-minutowy trening",
                description: "Intensywny trening składający się z 12 ćwiczeń.",
                restBetweenExercise: 10
            });

            workout.exercises.push({
                details: exercises[0],
                duration: 30
            });
            workout.exercises.push({
                details: exercises[1],
                duration: 30
            });
            workout.exercises.push({
                details: exercises[2],
                duration: 30
            });
            workout.exercises.push({
                details: exercises[3],
                duration: 30
            });
            workout.exercises.push({
                details: exercises[4],
                duration: 30
            });
            workout.exercises.push({
                details: exercises[5],
                duration: 30
            });
            workout.exercises.push({
                details: exercises[6],
                duration: 30
            });
            workout.exercises.push({
                details: exercises[7],
                duration: 30
            });
            workout.exercises.push({
                details: exercises[8],
                duration: 30
            });
            workout.exercises.push({
                details: exercises[9],
                duration: 30
            });
            workout.exercises.push({
                details: exercises[10],
                duration: 30
            });
            workout.exercises.push({
                details: exercises[11],
                duration: 30
            });
            workouts.push(workout);
        };

        service.getWorkout = function (name) {
                var result = null;
            angular.forEach(service.getWorkouts(), function (workout) {
                if (workout.name === name) result = angular.copy(workout);
            });
            return result;
        };

        service.updateWorkout = function (workout) {
            for (var i = 0; i < workouts.length; i++) {
                if (workouts[i].name === workout.name) {
                    workouts[i] = workout;
                    break;
                }
            }
            return workout;
        };
           
        service.addWorkout = function (workout) {
            if (workout.name) {
                workouts.push(workout);
                return workout;
            }
        }
        
        service.deleteWorkout = function (workoutName) {
            var workoutIndex;
            angular.forEach(workouts, function (w, index) {
                if (w.name === workoutName) {
                    workoutIndex = index;
                }
            });
            workouts.splice(workoutIndex, 1);
        };

        var init = function () {
            setupInitialExercises();
            setupInitialWorkouts();
        };

        init();

        return service;
    }]);

