import {Component, Input, ViewEncapsulation, ChangeDetectionStrategy} from '@angular/core';
import template from './efforts-timeline.html!text';

@Component({
  selector: 'ngc-efforts-timeline',
  host: {
    class: 'efforts-timeline'
  },
  template,
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class EffortsTimeline {
  @Input() estimated;
  @Input() effective;
  @Input() height;

  ngOnChanges(changes) {
    this.done = 0;
    this.overtime = 0;

    if (!this.estimated && this.effective || (this.estimated && this.estimated === this.effective)) {
      // Jeśli istnieje tylko czas faktycznie poniesiony lub estymacja jest mu równa, użyj wartości 100%.
      this.done = 100;
    } else if (this.estimated < this.effective) {
      // Jeśli faktyczny czas realizacji jest większy od estymacji, wylicz proporcje czasu standardowego i nadgodzin.
      this.done = this.estimated / this.effective * 100;
      this.overtime = 100 - this.done;
    } else {
      // Standardowy przypadek, w którym faktyczny czas jest mniejszy od estymacji.
      this.done = this.effective / this.estimated * 100;
    }
  }
}
