import { NgModule } from '@angular/core';

// Wczytaj moduł zawierający podstawowe dyrektywy.
import {CommonModule} from '@angular/common';
import {TagsModule} from '../tags/tags.module'

// Wczytaj moduł routera, bo jest wykorzystywany w zakładkach.
import {RouterModule} from '@angular/router';

// Wczytaj komponenty.
import {Checkbox} from './checkbox/checkbox';
import {Toggle} from './toggle/toggle';
import {Tabs} from './tabs/tabs';
import {Editor} from './editor/editor';
import {PipesModule} from "../pipes/pipes.module";
import {Duration} from "./duration/duration";
import {AutoComplete} from "./auto-complete/auto-complete";

// Utwórz moduł listy zadań.
@NgModule({
  declarations: [Checkbox, Toggle, Tabs, Editor, Duration, AutoComplete],
  imports: [CommonModule, RouterModule, TagsModule, PipesModule],
  exports: [Checkbox, Toggle, Tabs, Editor, Duration, AutoComplete]
})
export class UIModule {}
