// Potrzebujemy dekoratora Component oraz wyliczenia ViewEncapsulation.
import {Component, ViewEncapsulation, Inject} from '@angular/core';
import {ProjectService} from './project/project-service/project-service';
import {UserService} from './user/user-service/user-service';
import {ActivityService} from './activities/activity-service/activity-service';
import template from './app.html!text';

// W ten sposób tworzymy główną treść aplikacji.
@Component({
  // Informuje Angular, aby szukał elementu <ngc-app> w celu utworzenia tego komponentu.
  selector: 'ngc-app',
  // Wykorzystajmy treść wczytanego szablonu HTML.
  template,
  // Poinformuj Angular, aby ignorował enkapsulację widoku.
  encapsulation: ViewEncapsulation.None,
  providers: [ProjectService, UserService, ActivityService]
})
export class App {
  constructor(@Inject(ProjectService) projectService) {
    this.projectService = projectService;
    this.projects = [];

    // Konfiguracja subskrypcji RxJS w celu otrzymywania zmian w projekcie.
    this.projectsSubscription = projectService.change
      // Subskrybujemy zmiany w obserwatorze change.
      .subscribe((projects) => {
        this.projects = projects;
        // Tworzymy nowe elementy nawigacyjne dla projektu.
        this.projectNavigationItems = this.projects
          // Filtrujemy usunięte projekty.
          .filter((project) => !project.deleted)
          .map((project) => {
            return {
              title: project.title,
              link: ['/projects', project._id]
            };
          });
      });
  }

  // Jeśli komponent jest niszczony, musimy zakończyć subskrypcję.
  ngOnDestroy() {
    this.projectsSubscription.unsubscribe();
  }
}
