// Tablica z wartościami statusu 
var cacheStatusValues = [];
cacheStatusValues[0] = 'nieuwzględniane';
cacheStatusValues[1] = 'bezczynność';
cacheStatusValues[2] = 'sprawdzanie';
cacheStatusValues[3] = 'pobieranie';
cacheStatusValues[4] = 'zaktualizowane';
cacheStatusValues[5] = 'przeterminowane';

// Definicje funkcji obsługi możliwych zdarzeń  
var cache = window.applicationCache;
cache.addEventListener('cached', logEvent, false);
cache.addEventListener('checking', logEvent, false);
cache.addEventListener('downloading', logEvent, false);
cache.addEventListener('error', logEvent, false);
cache.addEventListener('noupdate', logEvent, false);
cache.addEventListener('obsolete', logEvent, false);
cache.addEventListener('progress', logEvent, false);
cache.addEventListener('updateready', logEvent, false);

// Wszystkie zdarzenia są wypisywane w konsoli
function logEvent(e) {  
   var online, status, type, message;
   online = (navigator.onLine) ? 'tak' : 'nie';
   status = cacheStatusValues[cache.status];
   type = e.type;
   message = 'tryb online: ' + online;
   message+= ', zdarzenie: ' + type;
   message+= ', status: ' + status;
   if (type == 'error' && navigator.onLine) {
      message+= ' (błąd składniowy w pliku manifestu)';
   }
   console.log(message);  
}

// Podmienia pobrane pliki po aktualizacji aplikacji
window.applicationCache.addEventListener(
   'updateready',
   function(){
      window.applicationCache.swapCache();
      console.log('wywołanie swapCache() - podmiana plików w pamięci trybu offline');
   },
   false
);

// Co 10 sekund sprawdza zmiany w manifeście
setInterval(function(){cache.update()}, 10000);
