package pl.twojadomena.rozdzial_9_a;

import java.util.Random;
import android.os.AsyncTask;
import android.os.Bundle;
import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

public class MainActivity extends Activity {
	private Button przycisk;
	private ImageView obraz;
	private TextView napis; 
	private ProgressBar stan;
	private Bitmap bmp;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        
        przycisk = (Button) findViewById(R.id.button1);
        obraz = (ImageView) findViewById(R.id.imageView1);
        napis = (TextView) findViewById(R.id.textView1);
        stan = (ProgressBar) findViewById(R.id.progressBar1);
        
        Bitmap temp = BitmapFactory.decodeResource(getResources(), R.drawable.palmy);
        bmp=temp.copy(Bitmap.Config.ARGB_8888, true);
    }
    public void kliknieto_start( View v)
    {
    	Proces p = new Proces();
    	p.execute();
    } 
//------------------------------------------------------------------------------
    class Proces extends AsyncTask<Void, Void, Void>
    {
    	private int nr, ile = 5000;
		@Override
		protected Void doInBackground(Void... arg) 
		{
	    	int szer = bmp.getWidth(), wys = bmp.getHeight();
	    	int x, y, kolor;
	    	int d = 20;
	    	Canvas c = new Canvas(bmp);
	    	Paint p = new Paint();
	    	p.setStyle(Paint.Style.STROKE);
	    	Random rand = new Random();
	    	for( nr = 0; nr < ile; nr ++)
	    	{
	    		x = rand.nextInt( szer);
	    		y = rand.nextInt( wys);
				kolor = bmp.getPixel(x, y);
		    	p.setColor( kolor);
				c.drawLine( x-d, y-d, x+d, y+d, p);
				c.drawLine( x-d, y+d, x+d, y-d, p);
				publishProgress();
	    	}
	    	p.setColor(Color.WHITE);
	    	p.setStyle(Paint.Style.STROKE);
	    	c.drawRect(0, 0, szer-1, wys-1, p);
			// TODO Auto-generated method stub
			return null;
		}
		@Override
		protected void onPreExecute() 
		{
			stan.setVisibility( ProgressBar.VISIBLE);
			przycisk.setEnabled(false);
			// TODO Auto-generated method stub
			super.onPreExecute();
		}
		@Override
		protected void onPostExecute(Void result) 
		{
		   	obraz.setImageBitmap(bmp);
			przycisk.setEnabled(true);
		   	napis.setText( "Koniec!");        
			stan.setVisibility( ProgressBar.INVISIBLE);
			// TODO Auto-generated method stub
			super.onPostExecute(result);
		}
		@Override
		protected void onProgressUpdate(Void... values)
		{
    		napis.setText( "Stan: " + nr + " / " + ile);
    		if( nr % 1000 == 0)
    	    	obraz.setImageBitmap(bmp);
			// TODO Auto-generated method stub
			super.onProgressUpdate(values);
		}
   }
}
