package com.gameproject.graphicstest;



import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.view.SurfaceHolder;
import android.view.SurfaceView;


public class GameView extends SurfaceView implements
		SurfaceHolder.Callback {

	private SpriteObject sprite;
	private GameLogic mGameLogic;

	public GameView(Context context) {
		super(context);
		getHolder().addCallback(this);
		sprite = new SpriteObject(BitmapFactory.decodeResource(getResources(), R.drawable.star), 50, 50);
		mGameLogic = new GameLogic(getHolder(), this);

		setFocusable(true);
	}

	@Override
	public void surfaceChanged(SurfaceHolder holder, int format, int width,
			int height) {
	}

	@Override
	public void surfaceCreated(SurfaceHolder holder) {
		mGameLogic.setGameState(mGameLogic.RUNNING);
		mGameLogic.start();
	}
	
	@Override
	public void surfaceDestroyed(SurfaceHolder holder) {
	}
	
	
	
	public void onDraw(Canvas canvas) {
		canvas.drawColor(Color.BLACK);
		sprite.draw(canvas);
	}

	public void update(int adj_mov) {
		if (sprite.getX() >= getWidth()){ 
			sprite.setMoveX(-2);
		}
		if (sprite.getX() <= 0){
			sprite.setMoveX(2);
		}
		sprite.update(adj_mov);

	}

	
}
